package com.liquidnet.service.goblin.service.impl.inner;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.PageReadListener;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.TempCouponDto;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.GoblinFrontService;
import com.liquidnet.service.goblin.service.manage.IGoblinInnerService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Slf4j
@Service
public class GoblinInnerServiceImpl implements IGoblinInnerService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinFrontService goblinFrontService;

    @Override
    public ResponseDto<String> insertCoupon(MultipartFile file, String performanceId) {
        try {
            EasyExcel.read(file.getInputStream(), TempCouponDto.class, new PageReadListener<TempCouponDto>(dataList -> {
                redisUtils.delMarketTempCoupon(performanceId);
                for (TempCouponDto data : dataList) {
                    if (data.getSpuId() == null) {
                        continue;
                    }
                    List<String> spuList = Arrays.asList(data.getSpuId().split(","));
                    TempCouponVo vo = TempCouponVo.getNew();
                    vo.setName(data.getName());
                    vo.setType(data.getType());
                    vo.setValue(data.getValue());
                    vo.setSpuIdList(spuList);
                    vo.setUcouponId(IDGenerator.nextTimeId2());
                    redisUtils.addMarketTempCoupon(performanceId, vo.getUcouponId());
                    redisUtils.setTempCoupon(vo.getUcouponId(), vo);
                }
            })).sheet().doRead();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseDto.success("完成");
    }

    @Override
    public ResponseDto<ArDataVo> getArData(String tag, String performanceId) {
        ArDataVo vo = ArDataVo.getNew();
        //券
        ArrayList<TempCouponVo> tempCouponVos = ObjectUtil.getTempCouponVo();
        List<String> ucouponIds = redisUtils.getMarketTempCoupon(performanceId);
        for (String ucouponId : ucouponIds) {
            TempCouponVo tempCouponVo = redisUtils.getTempCoupon(ucouponId);
            tempCouponVos.add(tempCouponVo);
        }
        vo.setTempCouponVos(tempCouponVos);
        //商品
        List<GoblinGoodsInfoVo> goodsInfoVos = goblinFrontService.getGoodByMusicTagP(tag, performanceId);
        for (GoblinGoodsInfoVo spuVo : goodsInfoVos) {
            List<GoblinGoodsSkuInfoVo> skuVoList = ObjectUtil.getGoblinGoodsSkuInfoVoArrayList();
            for (String skuId : spuVo.getSkuIdList()) {
                GoblinGoodsSkuInfoVo skuVo = redisUtils.getGoodsSkuInfoVo(skuId);
                skuVoList.add(skuVo);
            }
            spuVo.setGoblinOrderSkuVos(skuVoList);
        }
        vo.setGoodsInfoVos(goodsInfoVos);
        return ResponseDto.success(vo);
    }

    @Override
    public ResponseDto<TempCouponVo> getTempCouponData(String ucouponId) {
        TempCouponVo tempCouponVo = redisUtils.getTempCoupon(ucouponId);
        return ResponseDto.success(tempCouponVo);
    }
}
