package com.liquidnet.service.dragon.channel.wepay.strategy.impl;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.dragon.channel.wepay.resp.WepayPayRespDto;
import com.liquidnet.service.dragon.channel.wepay.strategy.annotation.StrategyWepayHandler;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.utils.PayWepayUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.SortedMap;
import java.util.TreeMap;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: AlipayStrategyWapImpl
 * @Package com.liquidnet.service.dragon.channel.alipay.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/10 14:34
 */
@Slf4j
@Component
@StrategyWepayHandler(DragonConstant.DeviceFromEnum.APP)
public class WepayStrategyAppImpl extends AbstractWepayStrategy {
    @Value("${liquidnet.dragon.url}")
    private String notifyUrl;

    @Override
    SortedMap<String, Object> appendRequestParam(SortedMap<String, Object> requestMap,DragonPayBaseReqDto dragonPayBaseReqDto) {
        requestMap.put("trade_type", "APP");
        requestMap.put("appid", PayWepayUtils.getInstance().getAPP_ID());
        return requestMap;
    }

    @Override
    DragonPayBaseRespDto buildResponseDto(DragonPayBaseRespDto payBaseRespDto, WepayPayRespDto respDto) {
        payBaseRespDto.getPayData().setPackages("Sign=WXPay");
        //设置签名
        SortedMap<String, Object> paramMap = new TreeMap<String, Object>();
        paramMap.put("appid", payBaseRespDto.getPayData().getAppId());
        paramMap.put("partnerid", payBaseRespDto.getPayData().getPartnerId());
        paramMap.put("prepayid", payBaseRespDto.getPayData().getPrepayId());
        paramMap.put("package", payBaseRespDto.getPayData().getPackages());
        paramMap.put("noncestr", payBaseRespDto.getPayData().getNonceStr());
        paramMap.put("timestamp", payBaseRespDto.getPayData().getTimeStamp());
        log.info("wepay sercond sign param :{} ", JsonUtils.toJson(paramMap));
        String sign = PayWepayUtils.getInstance().createSign(paramMap);
        payBaseRespDto.getPayData().setPaySign(sign);
        return payBaseRespDto;
    }

    @Override
    protected String getRequestUrl() {
        return "https://api.mch.weixin.qq.com/pay/unifiedorder";
    }

    @Override
    protected String getNotifyUrl() {
        return notifyUrl + "/notify/wepay/app";
    }

    @Override
    protected String getAppid() {
        return PayWepayUtils.getInstance().getAPP_ID();
    }
}
