package com.liquidnet.service.goblin.controller.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStorePurchaseItemParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStorePurchaseParam;
import com.liquidnet.service.goblin.dto.vo.GoblinPurchasingVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStorePurchasingService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 正在下单活动管理
 */
@Slf4j
@RestController
@Api(tags = "活动-正在下单")
@RequestMapping("store/zhengzai")
public class GoblinZhengzaiController {

    @Autowired
    IGoblinStorePurchasingService goblinStorePurchasingService;

    @GetMapping("zhengzai/list")
    @ApiOperation("活动详情-正在下单-可参与活动列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1")
    })
    public ResponseDto<Boolean> zhengzaiCanJoin(@RequestParam("storeId") @Valid String storeId) {
        return null;
    }

    @GetMapping("zhengzai/detals")
    @ApiOperation("活动详情-正在下单-可参与活动详情")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "selfMarketId", value = "官方活动id", example = "1")
    })
    public ResponseDto<Boolean> zhengzaiCanJoinDetails(@RequestParam("storeId") @Valid String storeId,
                                                       @RequestParam("selfMarketId") @Valid String selfMarketId) {
        return null;
    }

    @DeleteMapping("zhengzai/config")
    @ApiOperation("活动详情-正在下单-配置商铺")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "selfMarketId", value = "官方活动id", example = "1")
    })
    public ResponseDto<Boolean> zhengzaiStoreConfig(@RequestParam("storeId") @Valid String storeId,
                                                       @RequestParam("selfMarketId") @Valid String selfMarketId) {
        //todo
        return null;
    }

}
