package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketPartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketTimesPartnerVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.utils.DataUtils;
import com.liquidnet.service.kylin.utils.MongoVoUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;

@Service
public class DataImpl {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private KylinPerformancesMapper performancesMapper;
    @Autowired
    private KylinPerformanceStatusMapper performanceStatusMapper;
    @Autowired
    private KylinPerformanceRelationsMapper performanceRelationsMapper;
    @Autowired
    private KylinTicketTimesMapper ticketTimesMapper;
    @Autowired
    private KylinTicketTimeRelationMapper ticketTimeRelationMapper;
    @Autowired
    private KylinTicketsMapper ticketsMapper;
    @Autowired
    private KylinTicketStatusMapper ticketStatusMapper;
    @Autowired
    private KylinTicketRelationsMapper ticketRelationsMapper;
    @Autowired
    private DataUtils dataUtils;

    public boolean performance() {
        try {
            String driverClassName = "com.mysql.cj.jdbc.Driver";    //启动驱动
            String url = "jdbc:mysql://39.106.122.201:3308/testmall";    //设置连接路径
            String username = "testmall";    //数据库用户名
            String password = "zhengzai!mYT";    //数据库连接密码
            Connection con = null;        //连接
            PreparedStatement pstmt = null;    //使用预编译语句
            ResultSet rs = null;    //获取的结果集
            //演出实体类
            KylinPerformances performances = new KylinPerformances();
            KylinPerformanceRelations performanceRelations = new KylinPerformanceRelations();
            KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
            //场次实体类
            KylinTicketTimes ticketTimes = new KylinTicketTimes();
            KylinTicketTimeRelation ticketTimeRelation = new KylinTicketTimeRelation();
            //票实体类
            KylinTickets tickets = new KylinTickets();
            KylinTicketRelations ticketRelations = new KylinTicketRelations();
            KylinTicketStatus ticketStatus = new KylinTicketStatus();
            // 第三方Vo
            PerformancePartnerVo performancePartnerVo = new PerformancePartnerVo();
            KylinTicketTimesPartnerVo ticketTimesPartnerVo = new KylinTicketTimesPartnerVo();
            KylinTicketPartnerVo ticketPartnerVo = new KylinTicketPartnerVo();

            int count = 100;
            int page = 0;

            try {
                Class.forName(driverClassName); //执行驱动
                con = DriverManager.getConnection(url, username, password); //获取连接
                String sqlAllCount = "select count(0) as 'allCount' from performances where status >= 3"; //设置的预编译语句格式
                pstmt = con.prepareStatement(sqlAllCount);
                ResultSet allCount = pstmt.executeQuery();
                ArrayList<String> performanceIds = new ArrayList<>();
                int allCountResult = 0;//共多少条
                int rowCount = 0;//当前多少条
                boolean isBreak = false;//是否终端循环
                while (allCount.next()) {
                    allCountResult = allCount.getInt("allCount");
                }

                do {
                    String sql = "select * from performances where status >= 3 limit " + count * page + " ," + count; //设置的预编译语句格式
                    pstmt = con.prepareStatement(sql);
                    ResultSet resultData = pstmt.executeQuery();
                    int performanceId = 0;
                    //演出数据
                    while (resultData.next()) {
                        performanceId = resultData.getInt("id");
//                    performances.setPerformancesId(IDGenerator.nextSnowId().toString());
                        performances.setPerformancesId(resultData.getInt("id") + "");
                        performanceIds.add(performances.getPerformancesId());
                        performances.setTitle(resultData.getString("title"));
                        performances.setType(resultData.getInt("type") == 1 ? 101 : 102);
                        if (resultData.getInt("road_show_id") > 0) {
                            performances.setType(103);
                        }
                        performances.setImgPoster(resultData.getString("img_poster"));
                        performances.setApprovalUrl(resultData.getString("approval_url"));
                        performances.setNotice(resultData.getString("notice"));
                        performances.setSponsorId(resultData.getString("sponsor_id"));
                        performances.setSponsorType(resultData.getString("sponsor_type"));
                        performances.setSponsor(resultData.getString("sponsor"));
                        performances.setContacts(resultData.getString("contacts"));
                        performances.setMobile(resultData.getString("mobile"));
                        performances.setDescribes(resultData.getString("describe"));
                        performances.setDetails(resultData.getString("detail"));
                        performances.setNoticeImage("[{\"id\":1,\"sort\":1,\"text\":\"因演出票品非普通商品，其背后承载的文化服务具有时效性、稀缺性等特征，故不适用7天无理由退货政策。因“不可抗力”导致的演出取消或延期除外。\",\"title\":\"门票退换\",\"type\":\"image\",\"url\":\"http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c45722882a13.png\"},{\"id\":7,\"sort\":2,\"text\":\"凭订单二维码或手机号兑票入场，二维码或手机号请勿泄露，以免影响入场。个人原因导致的信息泄露，主办方/平台方不承担任何责任。\",\"title\":\"电子票\",\"type\":\"image\",\"url\":\"http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c456d9482fb9.png\"},{\"id\":3,\"sort\":3,\"text\":\"本场演出不设座位，均为站席观演。\",\"title\":\"仅设站席\",\"type\":\"image\",\"url\":\"http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c456e93db0b9.png\"},{\"id\":12,\"sort\":4,\"text\":\"每场现场票数量由场地方决定，具体请到现场询问。\",\"title\":\"现场票\",\"type\":\"image\",\"url\":\"http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/06/17/5d07647eaa55f.png\"}]");
                        performances.setTimeStart(DateUtil.Formatter.yyyyMMddHHmmssS.parse(resultData.getTimestamp("time_start").toString()));
                        performances.setTimeEnd(DateUtil.Formatter.yyyyMMddHHmmssS.parse(resultData.getTimestamp("time_end").toString()));
                        performances.setAuditTime(DateUtil.Formatter.yyyyMMddHHmmss.parse(resultData.getString("audit_submit_time")));
                        performances.setRejectTxt(resultData.getString("reject_text"));
                        performances.setSort(resultData.getInt("sort"));
                        performances.setComment("");
                        performances.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(resultData.getTimestamp("created_at").toString()));
                        if (null != resultData.getTimestamp("updated_at")) {
                            performances.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(resultData.getTimestamp("updated_at").toString()));
                        }
                        //Status
                        performanceStatus.setPerformanceStatusId(IDGenerator.nextSnowId().toString());
                        performanceStatus.setPerformanceId(performances.getPerformancesId());
                        performanceStatus.setIsShow(resultData.getInt("show"));
                        performanceStatus.setStatus(resultData.getInt("status"));
                        performanceStatus.setStatusSell(1);
                        performanceStatus.setIsDistribution(0);
                        performanceStatus.setSyncAgent(0);
                        performanceStatus.setSyncDamai(0);
                        performanceStatus.setAuditStatus(1);
                        performanceStatus.setIsTrueName(resultData.getString("need_id_card").equals("yes") ? 1 : 2);
                        performanceStatus.setLimitCount(resultData.getInt("num_limit_mobile"));
                        performanceStatus.setLimitCountMember(1);
                        performanceStatus.setIsRecommend(resultData.getInt("is_recommend"));
                        performanceStatus.setCreatedAt(performances.getCreatedAt());
                        performanceStatus.setUpdatedAt(performances.getUpdatedAt());
                        //Relation
                        performanceRelations.setPerformanceRelationsId(IDGenerator.nextSnowId().toString());
                        performanceRelations.setPerformanceId(performances.getPerformancesId());
                        performanceRelations.setCopyId(resultData.getInt("copy_id") + "");
                        performanceRelations.setMerchantId(resultData.getInt("merchant_id") + "");
                        performanceRelations.setFieldId(resultData.getInt("field_id") + "");
                        performanceRelations.setRoadShowId(resultData.getInt("road_show_id") + "");
                        performanceRelations.setProjectId("");
                        performanceRelations.setVideoId("");
                        performanceRelations.setCreatedAt(performances.getCreatedAt());
                        performanceRelations.setUpdatedAt(performances.getUpdatedAt());

                        performancesMapper.insert(performances);
                        performanceStatusMapper.insert(performanceStatus);
                        performanceRelationsMapper.insert(performanceRelations);

                        performancePartnerVo.setPerformancesId(performances.getPerformancesId());
                        performancePartnerVo.setImgPoster(performances.getImgPoster());
                        performancePartnerVo.setTitle(performances.getTitle());
                        performancePartnerVo.setType(performances.getType());
                        performancePartnerVo.setTimeStart(DateUtil.Formatter.yyyyMMddHHmmss.format(performances.getTimeStart()));
                        performancePartnerVo.setTimeEnd(DateUtil.Formatter.yyyyMMddHHmmss.format(performances.getTimeEnd()));
                        performancePartnerVo.setFieldId(performanceRelations.getFieldId());
//                        performancePartnerVo.setFieldName(performances.getFieldName());
                        performancePartnerVo.setNotice(performances.getNotice());
                        performancePartnerVo.setSponsorId(performances.getSponsorId());
                        performancePartnerVo.setSponsorType(performances.getSponsorType());
                        performancePartnerVo.setSponsor(performances.getSponsor());
                        performancePartnerVo.setContacts(performances.getContacts());
                        performancePartnerVo.setMobile(performances.getMobile());
                        performancePartnerVo.setDetails(performances.getDetails());
                        performancePartnerVo.setApprovalUrl(performances.getApprovalUrl());
                        performancePartnerVo.setPayCountdownMinute(5);
                        performancePartnerVo.setNoticeImage(performances.getNoticeImage());
                        performancePartnerVo.setIsTrueName(performanceStatus.getIsTrueName());
                        performancePartnerVo.setLimitCount(performanceStatus.getLimitCount());
                        performancePartnerVo.setIsSubmit(1);
                        performancePartnerVo.setStatus(performanceStatus.getStatus());
                        performancePartnerVo.setMerchantId(performanceRelations.getMerchantId());
                        performancePartnerVo.setDescribes(performances.getDescribes());
                        performancePartnerVo.setStatusSell(performanceStatus.getStatusSell());
                        performancePartnerVo.setRoadShowId(performanceRelations.getRoadShowId());
                        performancePartnerVo.setRejectTxt(performances.getRejectTxt());
                        performancePartnerVo.setAuditStatus(1);
                        performancePartnerVo.setIsShow(performanceStatus.getIsShow());
                        performancePartnerVo.setProjectId(performances.getProvinceId());
//                        performancePartnerVo.setNoticeIds();
                        performancePartnerVo.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(performances.getCreatedAt()));
                        performancePartnerVo.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(performances.getUpdatedAt()));
                        performancePartnerVo.setIsCreateSave(0);
                        mongoTemplate.insert(performancePartnerVo, PerformancePartnerVo.class.getSimpleName());

                        //场次相关
                        String timesSql = "select type,use_start,use_end,created_at from tickets where performance_id = " + performanceId + " GROUP BY use_start,use_end"; //设置的预编译语句格式
                        pstmt = con.prepareStatement(timesSql);
                        ResultSet timesData = pstmt.executeQuery();
                        HashMap<String, String> timeMap = new HashMap<>();
                        while (timesData.next()) {
                            String title = "";
                            String useStart = DateUtil.Formatter.yyyyMMddHHmmssS.parse(timesData.getTimestamp("use_start").toString()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
                            ;
                            String useEnd = DateUtil.Formatter.yyyyMMddHHmmssS.parse(timesData.getTimestamp("use_end").toString()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
                            ;
                            if (timesData.getInt("type") == 1) {
                                title = useStart;
                            } else {
                                title = useStart + "-" + useEnd;
                            }
                            //times
                            ticketTimes.setTicketTimesId(IDGenerator.nextSnowId().toString());
                            ticketTimes.setTitle(title);
                            ticketTimes.setType(timesData.getInt("type"));
                            ticketTimes.setStatus(1);
                            ticketTimes.setUseStart(DateUtil.Formatter.yyyyMMddHHmmssS.parse(timesData.getTimestamp("use_start").toString()));
                            ticketTimes.setUseEnd(DateUtil.Formatter.yyyyMMddHHmmssS.parse(timesData.getTimestamp("use_end").toString()));
                            ticketTimes.setComment("");
                            if (null != timesData.getTimestamp("created_at")) {
                                ticketTimes.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(timesData.getTimestamp("created_at").toString()));
                            }
                            ticketTimes.setUpdatedAt(null);
                            //Relation
                            ticketTimeRelation.setTicketTimeRelationId(IDGenerator.nextSnowId().toString());
                            ticketTimeRelation.setTimesId(ticketTimes.getTicketTimesId());
                            ticketTimeRelation.setPerformanceId(performanceId + "");
                            ticketTimeRelation.setCreatedAt(ticketTimes.getCreatedAt());
                            timeMap.put(title, ticketTimes.getTicketTimesId());

                            ticketTimesMapper.insert(ticketTimes);
                            ticketTimeRelationMapper.insert(ticketTimeRelation);
                            ticketTimesPartnerVo.setTicketTimesId(ticketTimes.getTicketTimesId());
                            ticketTimesPartnerVo.setPerformancesId(ticketTimeRelation.getPerformanceId());
                            ticketTimesPartnerVo.setType(ticketTimes.getType());
                            ticketTimesPartnerVo.setTitle(ticketTimes.getTitle());
                            ticketTimesPartnerVo.setStatus(ticketTimes.getStatus());
                            ticketTimesPartnerVo.setUseEnd(DateUtil.Formatter.yyyyMMddHHmmss.format(ticketTimes.getUseEnd()));
                            ticketTimesPartnerVo.setUseStart(DateUtil.Formatter.yyyyMMddHHmmss.format(ticketTimes.getUseStart()));
                            ticketTimesPartnerVo.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(ticketTimes.getCreatedAt()));
                            mongoTemplate.insert(ticketTimesPartnerVo, KylinTicketTimesPartnerVo.class.getSimpleName());
                        }

                        //票sql
                        String ticketSql = "select * from tickets where performance_id = " + performanceId; //设置的预编译语句格式
                        pstmt = con.prepareStatement(ticketSql);
                        ResultSet ticketData = pstmt.executeQuery();
                        while (ticketData.next()) {
                            //会员sql
                            String memberSql = "select status from performance_members where performance_id = " + performanceId; //设置的预编译语句格式
                            pstmt = con.prepareStatement(memberSql);
                            int isMember = 0;
                            ResultSet memberData = pstmt.executeQuery();
                            while (memberData.next()) {
                                isMember = memberData.getInt("status") == 1 ? 1 : 0;
                            }


                            String title = "";
                            String useStart = DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("use_start").toString()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
                            ;
                            String useEnd = DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("use_end").toString()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
                            ;
                            if (ticketData.getInt("type") == 1) {
                                title = useStart;
                            } else {
                                title = useStart + "-" + useEnd;
                            }
                            //Ticket
//                    tickets.setPerformancesId(IDGenerator.nextSnowId().toString());
                            tickets.setTicketsId(ticketData.getInt("id") + "");
                            tickets.setTitle(ticketData.getString("title"));
                            tickets.setType(ticketData.getInt("type"));
                            tickets.setPrice(ticketData.getBigDecimal("price"));
                            tickets.setPriceExpress(ticketData.getBigDecimal("price_express"));
                            tickets.setPriceDiscountMember(new BigDecimal("0.00"));
                            tickets.setPriceDiscount(new BigDecimal("0.00"));
                            tickets.setDescribes(ticketData.getString("describe_express"));
                            tickets.setDescribeExpress(ticketData.getString("describe_express"));
                            tickets.setDescribeElectronic(ticketData.getString("describe_electronic"));
                            tickets.setAdvanceMinuteMember(5);
                            tickets.setTimeStart(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("time_start").toString()));
                            tickets.setTimeEnd(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("time_end").toString()));
                            tickets.setTimeEndExpress(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("time_end_express").toString()));
                            tickets.setUseStart(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("use_start").toString()));
                            tickets.setUseEnd(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("use_end").toString()));
                            tickets.setPayCountdownMinute(5);
                            tickets.setSaleRemindMinute(60);
                            tickets.setComment("");
                            if (null != ticketData.getTimestamp("created_at")) {
                                tickets.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("created_at").toString()));
                            }
                            if (null != ticketData.getTimestamp("updated_at")) {
                                tickets.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("updated_at").toString()));
                            }
                            //Status
                            ticketStatus.setTicketStatusId(IDGenerator.nextSnowId().toString());
                            ticketStatus.setTicketId(tickets.getTicketsId());
                            ticketStatus.setIsStudent(ticketData.getString("student").equals("yes") ? 1 : 0);
                            ticketStatus.setIsElectronic(ticketData.getInt("is_electronic"));
                            ticketStatus.setIsExpress(ticketData.getInt("is_express"));
                            ticketStatus.setStatus(ticketData.getInt("status"));
                            ticketStatus.setCounts(1);
                            ticketStatus.setStatusExchange(7);
                            ticketStatus.setIsShowCode(0);
//                    ticketStatus.setQrCodeShowTime();
                            ticketStatus.setIsLackRegister(ticketData.getInt("is_lack_register"));
                            ticketStatus.setTotalGeneral(ticketData.getInt("total_general"));
                            ticketStatus.setTotalExchange(ticketData.getInt("total_exchange"));
                            ticketStatus.setSurplusGeneral(ticketData.getInt("surplus_general"));
                            ticketStatus.setSurplusExchange(ticketData.getInt("surplus_exchange"));
                            ticketStatus.setExpressType(ticketData.getInt("express_type"));
                            ticketStatus.setIsTrueName(ticketData.getString("need_id_card").equals("yes") ? 1 : 0);
                            ticketStatus.setLimitCount(0);
                            ticketStatus.setMemberLimitCount(1);
                            ticketStatus.setIsTransfer(0);
                            ticketStatus.setIsExclusive(ticketData.getInt("is_exclusive"));
                            ticketStatus.setIsMember(isMember);
                            ticketStatus.setIsAgent(0);
                            ticketStatus.setSyncDamai(0);
                            ticketStatus.setCreatedAt(tickets.getCreatedAt());
                            if (null != ticketData.getTimestamp("updated_at")) {
                                ticketStatus.setUpdatedAt(tickets.getUpdatedAt());
                            }
                            //Relation
                            ticketRelations.setTicketRelationsId(IDGenerator.nextSnowId().toString());
                            ticketRelations.setTicketId(tickets.getTicketsId());
                            ticketRelations.setTimesId(timeMap.get(title));
                            ticketRelations.setCreatedAt(tickets.getCreatedAt());
                            if (null != ticketData.getTimestamp("updated_at")) {
                                ticketRelations.setUpdatedAt(tickets.getUpdatedAt());
                            }

                            ticketsMapper.insert(tickets);
                            ticketStatusMapper.insert(ticketStatus);
                            ticketRelationsMapper.insert(ticketRelations);

                            dataUtils.setSurplusGeneral(tickets.getTicketsId(),ticketStatus.getSurplusGeneral());
                            dataUtils.setSurplusExchange(tickets.getTicketsId(),ticketStatus.getSurplusExchange());
                            //Vo
                            ticketPartnerVo.setTicketsId(tickets.getTicketsId());
                            ticketPartnerVo.setTitle(tickets.getTitle());
                            ticketPartnerVo.setIsStudent(ticketStatus.getIsStudent());
                            ticketPartnerVo.setIsElectronic(ticketStatus.getIsElectronic());
                            ticketPartnerVo.setIsExpress(ticketStatus.getIsExpress());
                            ticketPartnerVo.setType(tickets.getType());
                            ticketPartnerVo.setPrice(tickets.getPrice());
                            ticketPartnerVo.setTimeEndExpress(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getTimeEndExpress()));
                            ticketPartnerVo.setTotalGeneral(ticketStatus.getTotalGeneral());
                            ticketPartnerVo.setTotalExchange(ticketStatus.getTotalExchange());
                            ticketPartnerVo.setLimitCount(ticketStatus.getLimitCount());
                            ticketPartnerVo.setCounts(1);
                            ticketPartnerVo.setTimeStart(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getTimeStart()));
                            ticketPartnerVo.setTimeEnd(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getTimeEnd()));
                            ticketPartnerVo.setUseStart(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getUseStart()));
                            ticketPartnerVo.setUseEnd(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getUseEnd()));
                            ticketPartnerVo.setDescribes(tickets.getDescribes());
                            ticketPartnerVo.setDescribesExpress(tickets.getDescribeExpress());
                            ticketPartnerVo.setDescribeElectronic(tickets.getDescribeElectronic());
                            ticketPartnerVo.setStatus(ticketStatus.getStatus());
                            ticketPartnerVo.setIsShowCode(ticketStatus.getIsShowCode());
//                        ticketPartnerVo.setQrCodeShowTime();
                            ticketPartnerVo.setTimesId(ticketRelations.getTimesId());
                            ticketPartnerVo.setIsLackRegister(ticketStatus.getIsLackRegister());
                            ticketPartnerVo.setSurplusGeneral(ticketStatus.getSurplusGeneral());
                            ticketPartnerVo.setSurplusExchange(ticketStatus.getSurplusExchange());
                            ticketPartnerVo.setExpressType(ticketStatus.getExpressType());
                            ticketPartnerVo.setIsTransfer(ticketStatus.getIsTransfer());
                            ticketPartnerVo.setIsMember(ticketStatus.getIsMember());
                            ticketPartnerVo.setIsExclusive(ticketStatus.getIsExclusive());
                            ticketPartnerVo.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getCreatedAt()));
                            ticketPartnerVo.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getUpdatedAt()));
                            mongoTemplate.insert(ticketPartnerVo, KylinTicketPartnerVo.class.getSimpleName());

                        }
                    }

                    for (int i = 0; i < performanceIds.size(); i++) {
                        dataUtils.updatePerformanceMongo(performanceIds.get(i));
                    }

                    resultData.last();
                    rowCount += resultData.getRow();
                    if (allCountResult > rowCount) {
                        isBreak = true;
                        page+=1;
                    } else {
                        isBreak = false;
                    }
                } while (isBreak);
                return true;
            } catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            } finally {
                //关闭资源,倒关
                try {
                    if (rs != null) rs.close();
                    if (pstmt != null) pstmt.close();
                    if (con != null) con.close();  //必须要关
                } catch (Exception e) {
                }
            }
        } catch (Exception e) {
            return false;
        }
    }

}
