package com.liquidnet.client.admin.web.controller.zhengzai.smile;


import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.dto.UserCheckParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileUserCheckService;
import com.liquidnet.service.smile.entity.SmileUserCheck;
import com.liquidnet.service.smile.entity.dao.SmileUserCheckDao;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-15
 */
@Api(value ="审核管理")
@RestController
@RequestMapping("/smile/user/check")
public class SmileUserCheckController {

    @Autowired
    ISmileUserCheckService smileUserCheckService;

    @GetMapping("/list")
    @ApiOperation("获取审核列表")
    @ResponseBody
    public AjaxResult list(UserCheckParam userCheckParam) {
        PageInfo<SmileUserCheckDao> list = smileUserCheckService.listUserCheck(userCheckParam);
        return AjaxResult.success(list);
    }

    @PostMapping("/create")
    @ApiOperation("创建审核")
    @ResponseBody
    public AjaxResult create(@RequestBody SmileUserCheck smileUserCheck) {
        if (smileUserCheckService.create(smileUserCheck)) {
            return AjaxResult.success();
        }
        return AjaxResult.error();
    }

    @PostMapping("/updateById")
    @ApiOperation("修改审核")
    @ResponseBody
    public AjaxResult updateById(@RequestBody SmileUserCheck smileUserCheck) {
        if (smileUserCheckService.updateById(smileUserCheck)){
            return AjaxResult.success();
        }
        return AjaxResult.error();
    }
}
