package com.liquidnet.client.admin.web.controller.zhengzai.smile;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileUserParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileUserService;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileUserVo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileUserVoOrg;
import com.liquidnet.service.smile.entity.SmileUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
@Api(tags = "用户管理")
@Controller
@RequestMapping("/smile/user")
public class SmileUserController extends BaseController {

    @Autowired
    ISmileUserService iSmileUserService;

    @GetMapping("/list")
    @ApiOperation(value = "获取用户列表")
    @ResponseBody
    public AjaxResult userList(SmileUserParam smileUserParam){
        PageInfo<SmileUserVo> smileUserVos = iSmileUserService.userList(smileUserParam);
        return AjaxResult.success(smileUserVos);
    }

    @GetMapping("/getUserById")
    @ApiOperation(value = "更具ID查询单个用户完整信息")
    @ResponseBody
    public AjaxResult getUserById(@RequestParam(name = "uid",required = true) Long uid){
        SmileUser smileUser = iSmileUserService.getUserById(uid);
        return AjaxResult.success(smileUser);
    }

    @PostMapping("/create")
    @ApiOperation(value = "保存用户")
    @ResponseBody
    public AjaxResult create(@RequestBody SmileUser smileUser){
        int id = iSmileUserService.create(smileUser);
        return AjaxResult.success(id);
    }

    @GetMapping("/getUserListByOrgId")
    @ApiOperation(value = "根据组织ID查询相人员信息")
    @ResponseBody
    public AjaxResult getUserListByOrgId(@RequestParam(name = "orgId",required = true)Long orgId,@RequestParam(name = "agentId",required =true)Long agentId){
        logger.info("orgId:{},agentId:{}",orgId,agentId);
        List<SmileUserVoOrg> userListByOrgId = iSmileUserService.getUserListByOrgId(orgId, agentId);
        return AjaxResult.success(userListByOrgId);
    }
}
