package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "AdamLoginInfoVo", description = "登录成功响应数据")
public class AdamLoginInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 4209754800686327524L;
    @ApiModelProperty(position = 11, value = "TOKEN")
    private String token;
    @ApiModelProperty(position = 12, value = "用户信息")
    private AdamUserInfoVo userInfo;
//    @ApiModelProperty(position = 13, value = "实名信息")
//    private AdamRealInfoVo realNameInfo;
//    @ApiModelProperty(position = 14, value = "用户第三方账号信息")
//    private List<AdamThirdPartInfoVo> thirdPartInfo;
//    @ApiModelProperty(position = 15, value = "会员信息")
//    private AdamMemberSimpleVo memberVo;
    @ApiModelProperty(position = 16, value = "用户会员信息")
    private AdamUserMemberVo userMemberVo;
    @ApiModelProperty(position = 17, value = "业务账号信息")
    private List<AdamUserBizAcctVo> bizAcctVoList;

    @ApiModelProperty(position = 18, value = "微信用户openid（微信小程序登录返回，用于给小程序用户推送信息）")
    private String wechatOpenid;
    @ApiModelProperty(position = 19, value = "微信用户unionid（微信小程序登录返回，用于给小程序用户推送信息）")
    private String wechatUnionid;

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public AdamUserInfoVo getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(AdamUserInfoVo userInfo) {
        this.userInfo = userInfo;
    }

//    public AdamRealInfoVo getRealNameInfo() {
//        return realNameInfo;
//    }
//
//    public void setRealNameInfo(AdamRealInfoVo realNameInfo) {
//        this.realNameInfo = realNameInfo;
//    }
//
//    public List<AdamThirdPartInfoVo> getThirdPartInfo() {
//        return thirdPartInfo;
//    }
//
//    public void setThirdPartInfo(List<AdamThirdPartInfoVo> thirdPartInfo) {
//        this.thirdPartInfo = thirdPartInfo;
//    }
//
//    public AdamMemberSimpleVo getMemberVo() {
//        return memberVo;
//    }
//
//    public void setMemberVo(AdamMemberSimpleVo memberVo) {
//        this.memberVo = memberVo;
//    }

    public AdamUserMemberVo getUserMemberVo() {
        return userMemberVo;
    }

    public void setUserMemberVo(AdamUserMemberVo userMemberVo) {
        this.userMemberVo = userMemberVo;
    }

    public List<AdamUserBizAcctVo> getBizAcctVoList() {
        return bizAcctVoList;
    }

    public void setBizAcctVoList(List<AdamUserBizAcctVo> bizAcctVoList) {
        this.bizAcctVoList = bizAcctVoList;
    }

    public String getWechatOpenid() {
        return wechatOpenid;
    }

    public void setWechatOpenid(String wechatOpenid) {
        this.wechatOpenid = wechatOpenid;
    }

    public String getWechatUnionid() {
        return wechatUnionid;
    }

    public void setWechatUnionid(String wechatUnionid) {
        this.wechatUnionid = wechatUnionid;
    }

    private static final AdamLoginInfoVo obj = new AdamLoginInfoVo();

    public static AdamLoginInfoVo getNew() {
        try {
            return (AdamLoginInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamLoginInfoVo();
        }
    }

    /**
     * 脱敏处理
     *
     * @param reviewUserInfo 审核中开关配置
     * @return AdamLoginInfoVo
     */
    public AdamLoginInfoVo desensitize(Boolean reviewUserInfo) {
        this.userInfo.desensitize(reviewUserInfo);
        return this;
    }

    /**
     * 身份识别
     *
     * @return AdamLoginInfoVo
     */
    public AdamLoginInfoVo finalRating() {
        this.userInfo.rating(this.userMemberVo);
        return this;
    }
}
