package com.liquidnet.service.account.funding.dto;

import com.liquidnet.service.account.funding.dto.base.FundingCallResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * FundingRegisterResult.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/20
 */
@ApiModel(value = "FundingRegisterResult", description = "Result of funding account register")
public class FundingRegisterResult extends FundingCallResult<FundingRegisterParam> {
    private static final long serialVersionUID = 5763436491404776607L;
    @ApiModelProperty(position = 11, value = "Funding account number [32]")
    private String accNo;
    @ApiModelProperty(position = 12, value = "Funding account group ID [32]")
    private String accGroupId;

    public FundingRegisterResult() {
    }

    public FundingRegisterResult(String... accArr) {
        this.accNo = accArr[0];
        this.accGroupId = accArr[1];
    }

    public FundingRegisterResult(String code, String message) {
        super(code, message);
    }

    public String getAccNo() {
        return accNo;
    }

    public String getAccGroupId() {
        return accGroupId;
    }

    public void setAccGroupId(String accGroupId) {
        this.accGroupId = accGroupId;
    }
}
