package com.liquidnet.service.account.wallet.dto;

import com.liquidnet.service.account.common.FinConstants;
import com.liquidnet.service.account.wallet.dto.base.WalletCallParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * WalletDashboardParam.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/11/9
 */
@ApiModel(value = "WalletDashboardParam", description = "Parameters of wallet recent transaction")
public class WalletDashboardParam extends WalletCallParam {
    private static final long serialVersionUID = 5631199951710065819L;

    @ApiModelProperty(position = 11, required = true, value = "Wallet number [11]")
    private String walletNo;
    @ApiModelProperty(position = 12, required = true, value = "Dashboard period [enum]")
    private FinConstants.Dashboard.Period dashboardPeriod;
    @ApiModelProperty(position = 13, required = true, value = "Dashboard chart [enum]")
    private FinConstants.Dashboard.Chart dashboardChart;
    @ApiModelProperty(position = 14, required = false, value = "Wallet balance type [enum]")
    private FinConstants.Dashboard.Balance[] dashboardBalance;

    public String getWalletNo() {
        return walletNo;
    }

    public void setWalletNo(String walletNo) {
        this.walletNo = walletNo;
    }

    public FinConstants.Dashboard.Period getDashboardPeriod() {
        return dashboardPeriod;
    }

    public void setDashboardPeriod(FinConstants.Dashboard.Period dashboardPeriod) {
        this.dashboardPeriod = dashboardPeriod;
    }

    public FinConstants.Dashboard.Chart getDashboardChart() {
        return dashboardChart;
    }

    public void setDashboardChart(FinConstants.Dashboard.Chart dashboardChart) {
        this.dashboardChart = dashboardChart;
    }

    public FinConstants.Dashboard.Balance[] getDashboardBalance() {
        return dashboardBalance;
    }

    public void setDashboardBalance(FinConstants.Dashboard.Balance... dashboardBalance) {
        this.dashboardBalance = dashboardBalance;
    }

}
