package com.liquidnet.service.feign.adam.api;

import com.liquidnet.service.adam.dto.rsc.AdamChimeUinfoDto;
import com.liquidnet.service.adam.dto.rsc.AdamChimeUinfoReq;
import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Component
@FeignClient(name = "liquidnet-service-adam",
        contextId = "FeignAdamBaseClient", path = "adam",
        url = "${liquidnet.service.adam.url}",
        fallback = FallbackFactory.Default.class)
public interface FeignAdamBaseClient {

//    @GetMapping("adam/enters/query/depth")
//    ResponseDto<AdamEntersVo> queryEnters(@RequestParam("entersId") String entersId,
//                                                  @RequestParam("uid") String uid);
//
//    @GetMapping("adam/addr/query/depth")
//    ResponseDto<AdamAddressesVo> queryAddresses(@RequestParam(value = "addrId") String addrId,
//                                                        @RequestParam(value = "uid") String uid);
//
//    /**
//     * 判断是否会员
//     *
//     * @param uid 用户ID
//     * @return 是否会员：true-是
//     */
//    @GetMapping("adam/member/check/depth")
//    ResponseDto<Boolean> isMember(@RequestParam("uid") String uid);

    @PostMapping("rsc/inquire/cuinfo")
    ResponseDto<List<AdamChimeUinfoDto>> queryForChimeUserInfo(@RequestBody AdamChimeUinfoReq req);

    @PostMapping("rsc/inquire/sendMsgToRedis")
    ResponseDto<Boolean> sendMsgToRedis(@RequestParam("redisKey") String redisKey,@RequestParam("jsonParamStr") String jsonParamStr);
}
