package com.liquidnet.service.chime.service.impl;

import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.adam.dto.rsc.AdamChimeUinfoDto;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.chime.biz.ChimeUserBiz;
import com.liquidnet.service.chime.constant.ChimeConstant;
import com.liquidnet.service.chime.dto.ChimeUserInfoDto;
import com.liquidnet.service.chime.dto.ChimeUserRegisterReqDto;
import com.liquidnet.service.chime.dto.ChimeUserTagDto;
import com.liquidnet.service.chime.dto.ChimeUserUpdateReqDto;
import com.liquidnet.service.chime.service.IChimeUserService;
import com.liquidnet.service.chime.utils.DataUtils;
import com.liquidnet.service.chime.utils.QueueUtils;
import com.liquidnet.service.chime.vo.mongo.ChimeUserInfoVo;
import com.liquidnet.service.chime.vo.mongo.ChimeUserOperLogVo;
import com.liquidnet.service.chime.vo.mongo.ChimeUserTagsMappingVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ChimeUserServiceImpl
 * @Package com.liquidnet.service.chime.service.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/8 16:17
 */
@Slf4j
@Service
public class ChimeUserServiceImpl implements IChimeUserService {
    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private QueueUtils queueUtils;

    @Autowired
    private ChimeUserBiz chimeUserBiz;


    @Override
    public ChimeUserInfoVo createChimeUserInfo(ChimeUserRegisterReqDto reqDto) {
        try {
            ChimeUserInfoVo chimeUserInfoVo = ChimeUserInfoVo.getNew();
            if(StringUtil.isNotNull(reqDto)){
                chimeUserInfoVo.setUserId(reqDto.getUserId());
                chimeUserInfoVo.setSex(chimeUserBiz.getSexDesc(reqDto.getSex()));
                chimeUserInfoVo.setJoinPerformanceId("-1");
                List<ChimeUserTagsMappingVo> userTagList = chimeUserBiz.buildUserTagVoList(reqDto.getUserId(), reqDto.getTags());
                chimeUserInfoVo.setUserTagsVoList(userTagList);
                chimeUserInfoVo.setCreatedAt(LocalDateTime.now().toString());
                chimeUserInfoVo.setUpdatedAt(null);
                chimeUserInfoVo.setLikeCount(0l);
                chimeUserInfoVo.setDisLikeCount(0l);
                //插入mongo
                dataUtils.createChimeUser(chimeUserInfoVo);
            }
            return chimeUserInfoVo;
        } catch (Exception e) {
            log.error("创建社交用户异常 e：{}",e.getMessage());
        }
        return null;
    }

    @Override
    public boolean updateUserInfo(ChimeUserUpdateReqDto reqDto) {
        try {
            //插入userTagMapping
            ChimeUserInfoVo chimeUserInfoVo = ChimeUserInfoVo.getNew();
            List<ChimeUserTagsMappingVo> userTagList = chimeUserBiz.buildUserTagVoList(reqDto.getUserId(),reqDto.getTags());
            chimeUserInfoVo.setUserId(reqDto.getUserId());
            chimeUserInfoVo.setUserTagsVoList(userTagList);
            chimeUserInfoVo.setSex(chimeUserBiz.getSexDesc(reqDto.getSex()));
            chimeUserInfoVo.setUpdatedAt(LocalDateTime.now().toString());
            dataUtils.updateChimeUser(chimeUserInfoVo);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("updateUserInfo error msg:{}",e.getMessage());
            log.error("updateUserInfo error info:{}",e);
            return false;
        }
        return true;
    }

    @Override
    public boolean updateUserTags(ChimeUserUpdateReqDto reqDto) {
        //插入userTagMapping
        List<ChimeUserTagsMappingVo> userTagList = chimeUserBiz.buildUserTagVoList(reqDto.getUserId(),reqDto.getTags());
        return dataUtils.updateUserTagMapping(reqDto.getUserId(),userTagList);
    }

    @Override
    public ChimeUserInfoDto getUserByUserId(String userId) {
        //获取分页结果list中的userId
        List<String> userIdList = Arrays.asList(new String[]{userId});
        //批量获取用户信息
        List<AdamChimeUinfoDto> adamChimeUinfoDtoList = chimeUserBiz.getAdamUserInfoDtoList(userIdList);
        ChimeUserInfoVo chimeUserInfoVo = dataUtils.getUserByUserId(userId);
        if(StringUtil.isNotNull(chimeUserInfoVo)){
            ChimeUserInfoDto chimeUserInfoDto = ChimeUserInfoDto.getNew();
            BeanUtil.copy(chimeUserInfoVo,chimeUserInfoDto);
//            chimeUserInfoDto.setPassWord("123456");
            if(adamChimeUinfoDtoList!=null&&adamChimeUinfoDtoList.size()>0){
                AdamChimeUinfoDto adamChimeUinfoDto = adamChimeUinfoDtoList.get(0);
                chimeUserInfoDto.setNickName(adamChimeUinfoDto.getNickName());
                chimeUserInfoDto.setAvatar(adamChimeUinfoDto.getAvatar());
                chimeUserInfoDto.setUserCover(adamChimeUinfoDto.getUserCover());
                chimeUserInfoDto.setBirthday(adamChimeUinfoDto.getBirthday());
                chimeUserInfoDto.setSignature(adamChimeUinfoDto.getSignature());
                chimeUserInfoDto.setArea(adamChimeUinfoDto.getArea());
            }
            //获取标签
            List<ChimeUserTagDto> userTagDtoList = chimeUserBiz.buildUserTagDtoListFromVo(chimeUserInfoVo.getUserTagsVoList());
            chimeUserInfoDto.setUserTags(userTagDtoList);
            return chimeUserInfoDto;
        }
        return null;
    }

    @Override
    public boolean switchPerformanceId(String performanceId) {
        String userId = CurrentUtil.getCurrentUid();
        //获取社交用户
        ChimeUserInfoVo chimeUserInfoVo = dataUtils.getUserByUserId(userId);
        if(StringUtil.isNotNull(chimeUserInfoVo)){
            //判断演出id是否需要切换
            if(!chimeUserInfoVo.getJoinPerformanceId().equalsIgnoreCase(performanceId)){
                chimeUserInfoVo.setJoinPerformanceId(performanceId);
                dataUtils.updateChimeUser(chimeUserInfoVo);
            }
        }
        return true;
    }

    @Override
    public boolean userLikeOperation(String currentUserId, String targetUserId) {
        ChimeUserOperLogVo chimeUserOperLogVo = ChimeUserOperLogVo.getNew();
        chimeUserOperLogVo.setMid(ChimeConstant.getLogMid());
        chimeUserOperLogVo.setCurrentUserId(currentUserId);
        chimeUserOperLogVo.setTargetUserId(targetUserId);
        chimeUserOperLogVo.setOpType(ChimeConstant.LOG_USER_OPERATION_LIKE);
        chimeUserOperLogVo.setCreatedAt(LocalDateTime.now().toString());
        queueUtils.sendMsgByRedis(MQConst.ChimeQueue.USER_OPERATION_LIKE.getKey(), JsonUtils.toJson(chimeUserOperLogVo));
        return true;
    }

    @Override
    public boolean userDisLikeOperation(String currentUserId, String targetUserId) {
        ChimeUserOperLogVo chimeUserOperLogVo = ChimeUserOperLogVo.getNew();
        chimeUserOperLogVo.setMid(ChimeConstant.getLogMid());
        chimeUserOperLogVo.setCurrentUserId(currentUserId);
        chimeUserOperLogVo.setTargetUserId(targetUserId);
        chimeUserOperLogVo.setOpType(ChimeConstant.LOG_USER_OPERATION_DISLIKE);
        chimeUserOperLogVo.setCreatedAt(LocalDateTime.now().toString());
        queueUtils.sendMsgByRedis(MQConst.ChimeQueue.USER_OPERATION_DISLIKE.getKey(), JsonUtils.toJson(chimeUserOperLogVo));
        return true;
    }
}
