package com.liquidnet.service.example.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "example")
@RestController
@RequestMapping("emp")
public class ExampleController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "Simple test")
    @GetMapping(value = "test")
    public ResponseEntity<?> test(String str) {
        log.info("This is `service-example` api.test: {}", str);
        return ResponseEntity.ok("This is `service-example` api.test: " + str);
    }
}
