package com.liquidnet.client.admin.zhengzai.goblin.utils;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.dto.vo.GoblinMarketingZhengzaiRelationVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoblinRedisUtils {

    @Autowired
    RedisDataSourceUtil redisDataSourceUtil;

    /**
     * 覆盖店铺活动
     *
     * @param selfMarketId
     * @param data
     */
    public void setSelfMarket(String selfMarketId, GoblinSelfMarketingVo data) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SELF_MARKET.concat(selfMarketId);
        redisDataSourceUtil.getRedisGoblinUtil().set(redisKey, data);
    }

    /**
     * 正在下单 可参加商户
     *
     * @param selfMarketId
     * @param data
     */
    public void setZhengzaiRelation(String selfMarketId, GoblinMarketingZhengzaiRelationVo data) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_RELATION.concat(selfMarketId).concat(":store_id:"+data.getStoreId());
        redisDataSourceUtil.getRedisGoblinUtil().set(redisKey, data);
    }

    public void delZhengzaiRelation(String selfMarketId,String storeId){
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_RELATION.concat(selfMarketId).concat(":store_id:"+storeId);
         redisDataSourceUtil.getRedisGoblinUtil().del(redisKey);
    }
}
