package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商品单品
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsSku implements Serializable {

    private static final long serialVersionUID = 1L;

    private String skuId;

    /**
     * 商品id
     */
    private String spuId;

    /**
     * 单品的编号
     */
    private String skuNo;

    /**
     * 单品的名称
     */
    private String name;

    /**
     * 单品的副标题
     */
    private String subtitle;

    /**
     * 单品默认图片的url
     */
    private String skuPic;

    /**
     * ISBN，针对CD/图书等
     */
    private String skuIsbn;

    /**
     * 总库存
     */
    private Integer stock;

    /**
     * 单品库存
     */
    private Integer skuStock;

    /**
     * 预警库存
     */
    private Integer warningStock;

    /**
     * 单品价格
     */
    private BigDecimal price;

    /**
     * 单品会员价格
     */
    private BigDecimal priceMember;

    /**
     * 单品的重量
     */
    private BigDecimal weight;

    /**
     * 购买限制[0-全部用户|1-仅会员|2-指定用户]
     */
    private String buyFactor;

    /**
     * 购买限制为2-指定用户时必填指定用户
     */
    private String buyLimit;

    /**
     * 自定义展示[0-默认展示|1-隐藏不可购买]
     */
    private String skuAppear;

    /**
     * 单品有效期
     */
    private LocalDateTime skuValidity;

    /**
     * 审核状态[0-初始编辑|1-审核中|2-审核不通过|3-审核通过]
     */
    private String status;

    /**
     * 审核拒绝原因
     */
    private String reason;

    /**
     * 单品上架状态[0-待上架|1-下架|2-违规|3-上架]
     */
    private String shelvesStatus;

    /**
     * 是否是虚拟商品[0-否|1-是]
     */
    private String virtualFlg;

    /**
     * 删除标记[0-未删除|1删除]
     */
    private String delFlg;

    /**
     * 上架时间
     */
    private LocalDateTime shelvesAt;

    private String createdBy;

    private LocalDateTime createdAt;

    private String updatedBy;

    private LocalDateTime updatedAt;

    private String deletedBy;

    private LocalDateTime deletedAt;

    /**
     * 物流模版id
     */
    private String logisticsTemplate;

    private String comment;


}
