package com.liquidnet.client.admin.zhengzai.adam.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.client.admin.common.utils.DictUtils;
import com.liquidnet.service.goblin.dto.admin.GoblinNftOrderListDto;
import lombok.Data;

import java.io.Serializable;

@Data
public class GoblinNftOrderListExcelDto implements Serializable, Cloneable {

    private static final long serialVersionUID = 3382199237850214993L;

    @Excel(name = "用户ID", width = 30)
    private String userId;
    @Excel(name = "订单编号")
    private String orderCode;
    @Excel(name = "购买方式")
    private String orderType;
    @Excel(name = "支付方式")
    private String payType;
    @Excel(name = "实付金额")
    private String priceActual;
    @Excel(name = "订单状态")
    private String status;
    @Excel(name = "下单时间")
    private String createdAt;
    @Excel(name = "支付时间")
    private String payTime;
    @Excel(name = "藏品名称")
    private String name;
    @Excel(name = "上链时间")
    private String tradingAt;
    @Excel(name = "哈希值")
    private String nftId;

    private static final GoblinNftOrderListExcelDto obj = new GoblinNftOrderListExcelDto();

    public static GoblinNftOrderListExcelDto getNew() {
        try {
            return (GoblinNftOrderListExcelDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftOrderListExcelDto();
        }
    }

    public GoblinNftOrderListExcelDto copy(GoblinNftOrderListDto source) {
        if (null == source) return this;
        this.setUserId(source.getUserId());
        this.setOrderCode(source.getOrderCode());
        switch (source.getOrderType()) {
            case 1:
                this.setOrderType("购买");
                break;
            case 2:
                this.setOrderType("兑换");
                break;
            case 3:
                this.setOrderType("演出赠送");
                break;
            case 4:
                this.setOrderType("空投赠送");
                break;
            default:
                this.setOrderType("未知");
                break;
        }
        this.setPayType(DictUtils.getDictLabel("zhengzai_pay_type", String.valueOf(source.getPayType())));
        this.setPriceActual(source.getPriceActual());
        this.setStatus(DictUtils.getDictLabel("zhengzai_goblin_nft_order_status", String.valueOf(source.getStatus())));
        this.setCreatedAt(source.getCreatedAt());
        this.setPayTime(source.getPayTime());
        this.setName(source.getName());
        this.setTradingAt(source.getTradingAt());
        this.setNftId(source.getNftId());
        return this;
    }
}
