package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.param.GoblinMixDetailsItemParam;
import com.liquidnet.service.goblin.param.GoblinMixDetailsParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class GoblinMixDetailsItemVo implements Serializable, Cloneable {
    @ApiModelProperty(value = "spuId")
    private String spuId;
    @ApiModelProperty(value = "skuId")
    private String skuId;
    @ApiModelProperty(value = "skuId")
    private String skuPic;
    @ApiModelProperty(value = "sku名称")
    private String skuName;
    @ApiModelProperty(value = "spu名称")
    private String spuName;
    @ApiModelProperty(value = "商品类型[1-商城|2-数字藏品]")
    private String position;
    @ApiModelProperty(value = "sku原价")
    private BigDecimal skuPrice;
    @ApiModelProperty(value = "总库存")
    private Integer stock;
    @ApiModelProperty(value = "可配置库存")
    private Integer surplusStock;
    @ApiModelProperty(value = "组合价格")
    private BigDecimal price;
    @ApiModelProperty(value = "苹果价格")
    private BigDecimal priceV;
    @ApiModelProperty(value = "苹果价格id")
    private String productId;
    @ApiModelProperty(value = "组合件数[数字藏品不能大于1]")
    private Integer count;

    private static final GoblinMixDetailsItemVo obj = new GoblinMixDetailsItemVo();

    public static GoblinMixDetailsItemVo getNew() {
        try {
            return (GoblinMixDetailsItemVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinMixDetailsItemVo();
    }

    public GoblinMixDetailsItemVo copyByInsert(GoblinMixDetailsItemParam source) {
        if (null == source) return this;
        this.setSpuId(DateUtil.getNowTime());
        this.setSkuId(source.getSkuId());
        this.setSkuPrice(source.getSkuPrice());
        this.setPrice(source.getPrice());
        this.setPriceV(source.getPriceV());
        this.setProductId(source.getProductId());
        this.setCount(source.getCount());
        this.setPosition(source.getPosition());
        return this;
    }
}
