package com.liquidnet.service.adam.dto;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.io.Serializable;

@ApiModel(value = "AdamThirdPartParam", description = "第三方账号登录注册入参")
@Data
public class AdamThirdPartParam implements Serializable {
    private static final long serialVersionUID = 675588088506034208L;
    @ApiModelProperty(position = 11, required = true, value = "第三方账号唯一标识[64]")
    @NotBlank(message = "OPENID不能为空")
    private String openId;
    @ApiModelProperty(position = 12, required = true, value = "昵称[64]", example = "Swagger")
    private String nickname;
    @ApiModelProperty(position = 13, required = true, value = "头像[255]", example = "http://pic.zhengzai.tv/default/avatar.png")
    @Size(max = 255, message = "已超出头像链接长度限制")
    private String avatar;
    @ApiModelProperty(position = 14, required = true, value = "平台类型[255]", allowableValues = "WEIBO,WECHAT,QQ")
    @Pattern(regexp = LnsRegex.Valid.TRIPLE_PF_FOR_ULGOIN, message = "平台类型无效")
    @NotBlank(message = "平台类型不能为空")
    private String platform;
    @ApiModelProperty(position = 15, required = false, value = "手机号[新账号时必传]")
    private String mobile;
    @ApiModelProperty(position = 16, required = false, value = "验证码[新账号时必传]")
    private String code;
    @ApiModelProperty(position = 17, required = false, value = "强制绑定[第三方账号已绑定其他手机号时]", example = "false")
    private Boolean force;
}
