package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 订单退款退货操作日志表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinBackOrderLog implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单退单log表id
     */
    private String backOrderLogId;

    /**
     * 退款订单id
     */
    private String backOrderId;

    /**
     * 操作人类型[1-用户|2-商家]
     */
    private Integer operationType;

    /**
     * 留言
     */
    private String message;
    /**
     * 操作人
     */
    private String operationName;//todo
    /**
     * 退款申请[1-退款申请(用户发送退款请求)|2-退款成功(商家同意退款)|3-退款拒绝(商家拒绝退款)|4-退货申请(用户发起退货请求)|5-退货拒绝(商家拒绝退货)|6-退货审核通过等待用户填写物流(商家审核通过，等待用户寄回商品)|7-待收货(用户已确认)|8-退货完成(商家收货并且同意退款给用户)|9-退货失败(商家不同意退款)
     */
    private Integer status;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;

    private static final GoblinBackOrderLog obj = new GoblinBackOrderLog();

    public static GoblinBackOrderLog getNew() {
        try {
            return (GoblinBackOrderLog) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinBackOrderLog();
    }
}
