package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.sweet.utils.WechatSignUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

@Api(tags = "公众号动作回调")
@RestController
@RequestMapping("/actionCallback")
public class SweetActionCallbackController {

    @GetMapping("record")
    @ApiOperation("get")
    public void record(
            HttpServletResponse response,
            @RequestParam() String signature,
            @RequestParam() String timestamp,
            @RequestParam() String nonce,
            @RequestParam() String echostr
    ) {
        try {
            if (WechatSignUtils.checkSignature(signature, timestamp, nonce)) {
                PrintWriter out = response.getWriter();
                out.print(echostr);
                out.close();
            } else {
                System.out.println("这里存在非法请求！");
            }
        } catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @PostMapping("record")
    @ApiOperation("post")
    public void record() {
        System.out.println("这是post方法！");
    }
}
