package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import cn.hutool.core.text.UnicodeUtil;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinOrderRefundsServiceImpl;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dao.OrderRefundDao;
import com.liquidnet.service.kylin.dto.param.RefundApplyParam;
import com.liquidnet.service.kylin.dto.param.RefundSearchParam;
import com.liquidnet.service.kylin.dto.vo.admin.OrderDetailsAdminVo;
import com.liquidnet.service.kylin.dto.vo.returns.KylinOrderRefundsVo;
import com.liquidnet.service.kylin.dto.vo.returns.RefundOrderDetailsVo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * <p>
 * 后台单订单退款 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 10:58 上午
 */

@Controller
@RequestMapping("/kylin/refund")
public class KylinOrderRefundAdminController extends BaseController {

    private String prefix = "zhengzai/kylin/refund";

    @Autowired
    private KylinOrderRefundsServiceImpl kylinOrderRefundsServiceImpl;

    @RequiresPermissions("kylin:refund:view")
    @GetMapping()
    public String refund() {
        return prefix + "/refund";
    }

    @RequiresPermissions("kylin:refund:detail")
    @GetMapping(value = "/details/{orderRefundId}")
    public String detail(@PathVariable("orderRefundId") String orderRefundId, ModelMap mmap) {
        KylinOrderRefundsVo result = null;
        result = kylinOrderRefundsServiceImpl.detail(orderRefundId);
        mmap.put("KylinOrderRefundsVo", result);
        return prefix + "/details";
    }

    @RequiresPermissions("kylin:refund:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo refundList(RefundSearchParam refundSearchParam) {
        PageInfo<OrderRefundDao> result = kylinOrderRefundsServiceImpl.refundList(refundSearchParam);
        return getDataTable(result.getList());
    }

    @GetMapping("applyView")
    public String applyView() {
        return prefix +  "/applyView";
    }

    @PostMapping("applyOrder")
    @ResponseBody
    public RefundOrderDetailsVo applyOrder(RefundApplyParam refundApplyParam) {
        RefundOrderDetailsVo orderInfo = kylinOrderRefundsServiceImpl.orderDetails(refundApplyParam.getOrderCode());
        return orderInfo;
    }

    @RequiresPermissions("kylin:refund:apply")
    @PostMapping("apply")
    @ResponseBody
    public AjaxResult refundApply(RefundApplyParam refundApplyParam) {
        try {
            ResponseDto res = kylinOrderRefundsServiceImpl.refundApply(refundApplyParam);
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    @RequiresPermissions("kylin:refund:cancel")
    @PostMapping("cancel")
    @ResponseBody
    public AjaxResult refundCancel(RefundApplyParam refundApplyParam) {
        try {
            refundApplyParam.setType("cancel");
            ResponseDto res = kylinOrderRefundsServiceImpl.refundCheckStatus(refundApplyParam);
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    @RequiresPermissions("kylin:refund:reapply")
    @PostMapping("reapply")
    @ResponseBody
    public AjaxResult refundReapply(RefundApplyParam refundApplyParam) {
        try {
            refundApplyParam.setType("reapply");
            ResponseDto res = kylinOrderRefundsServiceImpl.refundCheckStatus(refundApplyParam);
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    // 一审
    @RequiresPermissions("kylin:refund:review")
    @PostMapping("review")
    @ResponseBody
    public AjaxResult refundReview(RefundApplyParam refundApplyParam) {
        try {
            ResponseDto res = null;
            Integer status = refundApplyParam.getStatus();
            if (status == KylinTableStatusConst.ORDER_REFUND_STATUS_APPROVED) { // 通过
                refundApplyParam.setType("approved");
                res = kylinOrderRefundsServiceImpl.refundCheckStatus(refundApplyParam);
            }
            if (status == KylinTableStatusConst.ORDER_REFUND_STATUS_REJECT) { // 驳回
                refundApplyParam.setType("reject");
                res = kylinOrderRefundsServiceImpl.refundCheckStatus(refundApplyParam);
            }
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    // 二审
    @RequiresPermissions("kylin:refund:execute")
    @PostMapping("execute")
    @ResponseBody
    public AjaxResult refundExecute(RefundApplyParam refundApplyParam) {
        try {
            ResponseDto res = null;
            Integer status = refundApplyParam.getStatus();
            if (status == KylinTableStatusConst.ORDER_REFUND_STATUS_UNFILLED) { // 通过
                refundApplyParam.setType("unfilled");
                res = kylinOrderRefundsServiceImpl.refundCheckStatus(refundApplyParam);
            }
            if (status == KylinTableStatusConst.ORDER_REFUND_STATUS_REFUSE) { // 驳回
                refundApplyParam.setType("refuse");
                res = kylinOrderRefundsServiceImpl.refundCheckStatus(refundApplyParam);
            }
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            String message = e.getMessage();
            String[] msg = e.getMessage().split(" ");
            if (msg.length>0 && null != msg[3]) {
                String msgStr = UnicodeUtil.toString(msg[3]);
                Map msgMap = JsonUtils.fromJson(msgStr.replace("[", "").replace("]", ""), Map.class);
                message = msgMap.get("message").toString();
            }
            return error(message);
        }
    }

    // 主动完成退款
    @RequiresPermissions("kylin:refund:completed")
    @PostMapping("completed")
    @ResponseBody
    public AjaxResult refundCompleted(RefundApplyParam refundApplyParam) {
        try {
            Boolean res = kylinOrderRefundsServiceImpl.refundCompleted(refundApplyParam);
            if (res) {
                return success();
            } else {
                return error("关闭订单失败");
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

}
