package com.liquidnet.client.admin.zhengzai.kylin.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.service.kylin.dao.OrderExportDao;
import lombok.Data;

import java.io.Serializable;

@Data
public class OrderExportVo implements Serializable, Cloneable{
    @Excel(name = "演出名称", cellType = Excel.ColumnType.STRING)
    private String performanceTitle;
    @Excel(name = "手机号", cellType = Excel.ColumnType.STRING)
    private String userMobile;
    @Excel(name = "姓名", cellType = Excel.ColumnType.STRING)
    private String userName;

    private static final OrderExportVo obj = new OrderExportVo();

    public static OrderExportVo getNew() {
        try {
            return (OrderExportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new OrderExportVo();
    }

    public OrderExportVo copyOrderExportVo(OrderExportDao source) {
        this.setPerformanceTitle(source.getPerformanceTitle());
        this.setUserMobile(source.getUserMobile());
        this.setUserName(source.getUserName());
        return this;
    }
}
