package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.GoblinGoodsSpecDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "GoblinNftGoodsSkuInfoVo", description = "NFT商品SKU信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinNftGoodsSkuInfoVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -519573757075729441L;

    @ApiModelProperty(position = 10, value = "商品单品ID")
    private String skuId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 12, value = "单品的编号[45]")
    private String skuNo;
    @ApiModelProperty(position = 13, value = "单品的名称[100]")
    private String name;
    @ApiModelProperty(position = 14, value = "单品的副标题[128]")
    private String subtitle;
    @ApiModelProperty(position = 15, value = "单品默认图片的URL[256]")
    private String skuPic;
    @ApiModelProperty(position = 15, value = "单品详情展示文件URL[256]")
    private String skuWatch;

    @ApiModelProperty(position = 20, value = "单品销售价-原价[20,2]")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 21, value = "单品现价[20,2]")
    private BigDecimal price;
    @ApiModelProperty(position = 22, value = "单品会员价格[20,2]")
    private BigDecimal priceMember;

    @ApiModelProperty(position = 23, value = "单品简介[256]", example = "单品简介...")
    private String intro;
    @ApiModelProperty(position = 23, value = "单品详情", example = "单品详情...")
    private String details;

    @ApiModelProperty(position = 24, value = "购买限制[0-全部用户|1-仅会员|2-指定用户]")
    private String buyFactor;
    @ApiModelProperty(position = 25, value = "购买限制人员名单[购买限制为2-指定用户时必填]")
    private String buyRoster;
    @ApiModelProperty(position = 26, value = "限量[0-无限制|X:限购数量]")
    private Integer buyLimit;

    @ApiModelProperty(position = 27, value = "商品的店铺ID，如果是平台的则为0")
    private String storeId;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 27, value = "开售时间")
    private LocalDateTime saleStartTime;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 27, value = "停售时间")
    private LocalDateTime saleStopTime;
    @ApiModelProperty(position = 28, value = "单品有效期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime skuValidity;

    @ApiModelProperty(position = 30, value = "审核状态[0-初始编辑|1-审核中|2-审核不通过|3-审核通过]")
    private String status;
    @ApiModelProperty(position = 32, value = "单品上架状态[0-待上架|1-下架|2-违规|3-上架]")
    private String shelvesStatus;

    @ApiModelProperty(position = 33, value = "自定义展示[0-默认展示|1-隐藏不可购买]")
    private String skuAppear;

    @ApiModelProperty(position = 33, value = "是否盲盒[0-否|1-是]")
    private String unbox;
    @ApiModelProperty(position = 33, value = "盲盒开启时间")
    private LocalDateTime openingTime;
    @ApiModelProperty(position = 33, value = "盲盒开启时限[单位秒]")
    private Integer openingLimit;

    @ApiModelProperty(position = 33, value = "NFT路由")
    private String routeType;
    @ApiModelProperty(position = 33, value = "NFT上传声明状态[0-待上传|1-已上传|2-上传失败|9-上传中]")
    private Integer upchain;
    @ApiModelProperty(position = 33, value = "NFT预览图访问URL")
    private String displayUrl;
    @ApiModelProperty(position = 33, value = "NFT素材访问URL")
    private String nftUrl;
    @ApiModelProperty(position = 33, value = "NFT系列ID")
    private String seriesId;
    @ApiModelProperty(position = 33, value = "NFT系列HASH")
    private String seriesHash;
    @ApiModelProperty(position = 33, value = "NFT藏品HASH")
    private String nftHash;
    @ApiModelProperty(position = 33, value = "NFT系列声明时间")
    private String declareAt;

    @ApiModelProperty(position = 35, value = "上架时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime shelvesAt;

    @ApiModelProperty(position = 40, value = "单品规格信息")
    private List<GoblinGoodsSpecDto> skuSpecList;
    @ApiModelProperty(position = 54, value = "单品音乐人标签[藏品类型时使用]")
    private List<GoblinGoodsExtagVo> extagVoList;

    @ApiModelProperty(position = 55, value = "spu相关信息")
    private GoblinNftGoodsSpuInfoVo goblinNftGoodsSpuInfoVo;

    @ApiModelProperty(position = 56, value = "是否还有库存 0没有库存 1有库存")
    private int isStock;
    @ApiModelProperty(position = 57, value = "还可以购买数量")
    private int canBuyNum;

    private static final GoblinNftGoodsSkuInfoVo obj = new GoblinNftGoodsSkuInfoVo();

    public static GoblinNftGoodsSkuInfoVo getNew() {
        try {
            return (GoblinNftGoodsSkuInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftGoodsSkuInfoVo();
        }
    }
}
