package com.liquidnet.service.order.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.codec.vo.EncryptedReq;
import com.liquidnet.service.goblin.dto.vo.GoblinBraceletPayResultVo;
import com.liquidnet.service.goblin.param.GoblinBraceletOrderPayParam;
import com.liquidnet.service.goblin.service.IGoblinBraceLetOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;

@Slf4j
@Api(tags = "商城-手环相关")
@RestController
@RequestMapping("/goblin/bracelet")
public class GoblinBraceletOrderController {

    @Autowired
    private IGoblinBraceLetOrderService braceLetOrderService;

    @PostMapping("/pre")
//    @ApiOperation("下单(加密)")
    public ResponseDto<GoblinBraceletPayResultVo> checkOrder(@RequestBody @Valid EncryptedReq<GoblinBraceletOrderPayParam> payParam) {
        return braceLetOrderService.checkOrder(payParam.getData());
    }

    @PostMapping("/fc7bce6d6c2213b866f76493f92224b8")
    @ApiOperation("下单(非加密)")
    public ResponseDto<GoblinBraceletPayResultVo> checkOrder(@RequestBody @Valid GoblinBraceletOrderPayParam payParam) {
        return braceLetOrderService.checkOrder(payParam);
    }


    @PostMapping("/checkPayment")
    @ApiOperation("查询订单状态")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单ID", example = "1"),
    })
    public ResponseDto<Integer> checkOrderResult(@RequestParam("orderId") @NotBlank(message = "订单ID不能为空") String orderId) {
        return braceLetOrderService.checkOrderResult(orderId);
    }


    @PostMapping("/callback")
    @ApiOperation("斗拱支付回调")
    public ResponseDto<Boolean> dougongCallBack() {
        return braceLetOrderService.dougongCallBack();
    }

}
