package com.liquidnet.service.account.wallet.dto.base;

import com.liquidnet.service.account.common.FinConstants;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * WalletContextParam.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/21
 */
public class WalletContextParam implements Cloneable {
    private String channelId;
    private String bizType;
    private String tradeType;
    private String tradeNo;
    // User association ID
    private String userExtId;
    // User association name
    private String userExtName;
    private String finId;
    private String walletNo;
    private String currency;
    private String alias;
    private Integer status;
    private Integer payStatus;

    private FinConstants.TransType transType;
    private BigDecimal amount;
    private String tracingType;
    private String tracingNo;
    private LocalDateTime tracingTime;
    private String tracingTitle;
    private String tracingDesc;

    private String transNo;

    private LocalDateTime createTime;
    private LocalDateTime startTime;
    private LocalDateTime endTime;

    private String operator;

    private String fuzzySearch;
    private Integer fuzzyField;

    private Integer pageNum;
    private Integer pageSize;

    private LocalDateTime limitedTime;
    private Integer limitedSize;

    private List<String> strList;
    private String strListType;

    private FinConstants.Dashboard.Period dashboardPeriod;

    private FinConstants.Dashboard.Chart dashboardChart;

    private FinConstants.Dashboard.Balance[] dashboardBalance;

    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getTradeType() {
        return tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getUserExtId() {
        return userExtId;
    }

    public void setUserExtId(String userExtId) {
        this.userExtId = userExtId;
    }

    public String getUserExtName() {
        return userExtName;
    }

    public void setUserExtName(String userExtName) {
        this.userExtName = userExtName;
    }

    public String getFinId() {
        return finId;
    }

    public void setFinId(String finId) {
        this.finId = finId;
    }

    public String getWalletNo() {
        return walletNo;
    }

    public void setWalletNo(String walletNo) {
        this.walletNo = walletNo;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public FinConstants.TransType getTransType() {
        return transType;
    }

    public void setTransType(FinConstants.TransType transType) {
        this.transType = transType;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getTracingType() {
        return tracingType;
    }

    public void setTracingType(String tracingType) {
        this.tracingType = tracingType;
    }

    public String getTracingNo() {
        return tracingNo;
    }

    public void setTracingNo(String tracingNo) {
        this.tracingNo = tracingNo;
    }

    public LocalDateTime getTracingTime() {
        return tracingTime;
    }

    public void setTracingTime(LocalDateTime tracingTime) {
        this.tracingTime = tracingTime;
    }

    public String getTracingTitle() {
        return tracingTitle;
    }

    public void setTracingTitle(String tracingTitle) {
        this.tracingTitle = tracingTitle;
    }

    public String getTracingDesc() {
        return tracingDesc;
    }

    public void setTracingDesc(String tracingDesc) {
        this.tracingDesc = tracingDesc;
    }

    public String getTransNo() {
        return transNo;
    }

    public void setTransNo(String transNo) {
        this.transNo = transNo;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getStartTime() {
        return startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public LocalDateTime getEndTime() {
        return endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getFuzzySearch() {
        return fuzzySearch;
    }

    public void setFuzzySearch(String fuzzySearch) {
        this.fuzzySearch = fuzzySearch;
    }

    public Integer getFuzzyField() {
        return fuzzyField;
    }

    public void setFuzzyField(Integer fuzzyField) {
        this.fuzzyField = fuzzyField;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public LocalDateTime getLimitedTime() {
        return limitedTime;
    }

    public void setLimitedTime(LocalDateTime limitedTime) {
        this.limitedTime = limitedTime;
    }

    public Integer getLimitedSize() {
        return limitedSize;
    }

    public void setLimitedSize(Integer limitedSize) {
        this.limitedSize = limitedSize;
    }

    public List<String> getStrList() {
        return strList;
    }

    public void setStrList(List<String> strList) {
        this.strList = strList;
    }

    public String getStrListType() {
        return strListType;
    }

    public void setStrListType(String strListType) {
        this.strListType = strListType;
    }

    public FinConstants.Dashboard.Period getDashboardPeriod() {
        return dashboardPeriod;
    }

    public void setDashboardPeriod(FinConstants.Dashboard.Period dashboardPeriod) {
        this.dashboardPeriod = dashboardPeriod;
    }

    public FinConstants.Dashboard.Chart getDashboardChart() {
        return dashboardChart;
    }

    public void setDashboardChart(FinConstants.Dashboard.Chart dashboardChart) {
        this.dashboardChart = dashboardChart;
    }

    public FinConstants.Dashboard.Balance[] getDashboardBalance() {
        return dashboardBalance;
    }

    public void setDashboardBalance(FinConstants.Dashboard.Balance[] dashboardBalance) {
        this.dashboardBalance = dashboardBalance;
    }

    private static final WalletContextParam obj = new WalletContextParam();

    public static WalletContextParam getNew() {
        try {
            return (WalletContextParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new WalletContextParam();
    }
}
