package com.liquidnet.service.kylin.dto.vo.ticketSystem;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel
public class HallListVo implements Serializable {
    private static final long serialVersionUID = 4073256621782131607L;
    @ApiModelProperty(value = "场厅名称")
    private String hallName;
    @ApiModelProperty(value = "场厅编码[上报数据使用]")
    private String hallCode;
    @ApiModelProperty(value = "是否有座[是否有座，0：无座1：有座]")
    private Integer hasSeat;
    @ApiModelProperty(value = "场厅座位数量[有座时不为空]")
    private Integer seatNum;
    @ApiModelProperty(value = "可容纳人数[无座时不为空]")
    private Integer seatingCapacity;
    @ApiModelProperty(value = "经营状态[经营状态，1：经营中，2：装修中，3：已停运]")
    private Integer managementStatus;
    @ApiModelProperty(value = "可用状态[0：禁用，1：启用]")
    private Integer enableState;
}
