package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualSort;
import com.liquidnet.service.sweet.entity.SweetRichtext;
import com.liquidnet.service.sweet.mapper.SweetRichtextMapper;
import com.liquidnet.service.sweet.service.ISweetRichtextService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 电子宣传手册富文本表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Service
public class SweetRichtextServiceImpl extends ServiceImpl<SweetRichtextMapper, SweetRichtext> implements ISweetRichtextService {

    @Autowired
    private SweetRichtextMapper sweetRichtextMapper;
    @Autowired
    private RedisDataUtils redisDataUtils;

    @Override
    public ResponseDto<SweetRichtext> get(String manualId, Integer type) {
        try {
            return ResponseDto.success(sweetRichtextMapper.selectOne(Wrappers.lambdaQuery(SweetRichtext.class).eq(SweetRichtext::getManualId, manualId).eq(SweetRichtext::getType, type)));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String details, String local, String pirUrl, Integer type) {
        try {
            SweetRichtext sweetRichtext = new SweetRichtext();
            sweetRichtext.setRichtextId(IDGenerator.nextSnowId());
            sweetRichtext.setManualId(manualId);
            if (type == 5) {
                sweetRichtext.setLocal(local);
                sweetRichtext.setDetails(details);
            } else if (type == 2) {
                sweetRichtext.setPicUrl(pirUrl);
            }else{
                sweetRichtext.setDetails(details);
            }
            sweetRichtext.setType(type);
            sweetRichtext.setCreatedAt(LocalDateTime.now());
            sweetRichtextMapper.insert(sweetRichtext);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> change(String manualId, String details, String local, String pirUrl, Integer type) {
        try {
            SweetRichtext sweetRichtext = new SweetRichtext();
            sweetRichtext.setRichtextId(IDGenerator.nextSnowId());
            sweetRichtext.setManualId(manualId);
            sweetRichtext.setDetails(details);
            if (type == 5) {
                sweetRichtext.setLocal(local);
            } else if (type == 2) {
                sweetRichtext.setPicUrl(pirUrl);
            }
            sweetRichtext.setType(type);
            sweetRichtext.setCreatedAt(LocalDateTime.now());
            sweetRichtextMapper.update(sweetRichtext, Wrappers.lambdaUpdate(SweetRichtext.class).eq(SweetRichtext::getManualId, manualId).eq(SweetRichtext::getType, type));

            redisDataUtils.setRichTextRedisData(manualId,type.toString(),sweetRichtext);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }
}
