package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@ApiModel
@Data
public class GoblinStoreBackOrderListVo implements Cloneable {
    @ApiModelProperty(value = "退款订单id")
    private String backOrderId;
    @ApiModelProperty(value = "订单号")
    private String backCode;
    @ApiModelProperty(value = "下单时间")
    private String orderCode;
    @ApiModelProperty(value = "下单方式")
    private String type;
    @ApiModelProperty(value = " 收货人姓名")
    private String status;
    @ApiModelProperty(value = " 收货人联系方式")
    private String realBackPrice;
    @ApiModelProperty(value = " 收货人地址")
    private String createdAt;
    @ApiModelProperty(value = "退款sku")
    private List<GoblinBackOrderSkuVo> backOrderSkuVos;



    private static final GoblinStoreBackOrderListVo obj = new GoblinStoreBackOrderListVo();

    public static GoblinStoreBackOrderListVo getNew() {
        try {
            return (GoblinStoreBackOrderListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreBackOrderListVo();
        }
    }
}
