package com.liquidnet.service.feign.kylin.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;

@Component
@FeignClient(name = "liquidnet-service-kylin",
        contextId = "FeignKylinTaskClient", path = "",
        fallback = FallbackFactory.Default.class)
public interface FeignKylinTaskClient {

    @PostMapping("order/checkOrderTime")
    ResponseDto<Boolean> checkOrderTime();

    @PostMapping("performance/checkPerformanceTime")
    ResponseDto<String> checkPerformanceTime();
}
