package com.liquidnet.service.feign.platform.api;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;

@Component
@FeignClient(
        name = "liquidnet-service-platform",
        contextId = "FeignPlatformApiClient",
        path = "platform",
        url = "${liquidnet.service.platform.url}",
        fallback = FallbackFactory.Default.class
)
public interface FeignPlatformApiClient {

    @GetMapping("refund/overtimeRefund")
    ResponseDto<String> overtimeRefund();

    @GetMapping("camera/detectPedestrian")
    ResponseDto<String> detectPedestrian();

}
