package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.IGoblinStoreZhengzaiService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.liquidnet.service.goblin.util.QueueUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

@Service
public class GoblinStoreZhengzaiServiceImpl implements IGoblinStoreZhengzaiService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    QueueUtils queueUtils;


    @Override
    public ResponseDto<List<GoblinSelfMarketingVo>> getZhengzaiMarketList() {
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("店铺不存在");
        }
        String storeId = storeInfoVo.getStoreId();
        List<String> marketIds = redisUtils.getStoreZhengzaiRelation(storeId);//可参加的正在活动id
        List<GoblinSelfMarketingVo> list = redisUtils.getGoblinSelfMarketingVoList();//所有正在下单活动列表
        List<GoblinSelfMarketingVo> voList = ObjectUtil.getGoblinSelfMarketingVoList();
        LocalDateTime now = LocalDateTime.now();
        for (GoblinSelfMarketingVo item : list) {
            GoblinMarketingZhengzaiRelationVo zhengzaiRelationVo = redisUtils.getZhengzaiRelation(item.getSelfMarketId(), storeId);
            if (LocalDateTime.parse(item.getEndTime(), DTF_YMD_HMS).isAfter(now) && zhengzaiRelationVo != null ) {
                if (marketIds.contains(item.getSelfMarketId())) {
                    List<GoblinMarketRelationVo> relationVo = redisUtils.getMarketRelation(GoblinStatusConst.MarketPreStatus.MARKET_PRE_ZHENGZAI.getValue(), item.getSelfMarketId());
                    List<String> storeIdList = relationVo.stream().map(GoblinMarketRelationVo::getStoreId).distinct().collect(Collectors.toList());//配置了商铺的店铺
                    if (storeIdList.contains(storeId)) {
                        voList.add(item);
                    }
                }
            }
        }
        return ResponseDto.success(voList);
    }

    @Override
    public ResponseDto<List<GoblinZhengzaiGoodVo>> getSpuList(String marketId) {
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("店铺不存在");
        }
        String storeId = storeInfoVo.getStoreId();
        List<GoblinMarketRelationVo> relationVo = redisUtils.getMarketRelation(GoblinStatusConst.MarketPreStatus.MARKET_PRE_ZHENGZAI.getValue(), marketId);
        List<String> spuIdList = relationVo.stream().map(GoblinMarketRelationVo::getSpuId).collect(Collectors.toList());
        List<GoblinZhengzaiGoodVo> voList = ObjectUtil.getGoblinZhengzaiGoodVoArrayList();
        for (String spuId : spuIdList) {
            GoblinGoodsInfoVo vo = redisUtils.getGoodsInfoVo(spuId);
            if (vo.getStatus().equals("3") && vo.getStoreId().equals(storeId)) {
                GoblinZhengzaiGoodVo returnVo = GoblinZhengzaiGoodVo.getNew();
                BeanUtils.copyProperties(vo, returnVo);
                voList.add(returnVo);
            }
        }
        return ResponseDto.success(voList);
    }
}
