package com.liquidnet.service.kylin.dto.vo.partner;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.entity.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


/**
 * 修改场地全部显示数据参数
 */
@Data
public class KylinTicketPartnerVo implements Serializable,Cloneable {
    @ApiModelProperty(value = "主键")
    private String ticketsId;

    @ApiModelProperty(value = "票种名称", example = "测试票")
    private String title;

    @ApiModelProperty(value = "是否学生票 0否 1是", example = "0", hidden = true)
    private Integer isStudent;

    @ApiModelProperty(value = "是否电子票", example = "0")
    private Integer isElectronic;

    @ApiModelProperty(value = "是否快递票", example = "0")
    private Integer isExpress;

    @ApiModelProperty(value = "类型", example = "2")
    private Integer type;

    @ApiModelProperty(value = "价格", example = "100.00")
    private BigDecimal price;

    @ApiModelProperty(value = "快递票截止日期", example = "2020-12-01T12:00:00")
    private String timeEndExpress;

    @ApiModelProperty(value = "总库存", example = "100")
    private Integer totalGeneral;

    @ApiModelProperty(value = "总兑换库存", example = "100")
    private Integer totalExchange;

    @ApiModelProperty(value = "限购数量", example = "0")
    private Integer limitCount;

    @ApiModelProperty(value = "限购数量", example = "0")
    private Integer idCount;

    @ApiModelProperty(value = "次数", example = "0")
    private Integer counts;

    @ApiModelProperty(value = "票种开售时间", example = "2020-12-01T12:00:00")
    private String timeStart;

    @ApiModelProperty(value = "票种结售时间", example = "2020-12-01T14:00:00")
    private String timeEnd;

    @ApiModelProperty(value = "票种适用开始时间", example = "2020-12-01T12:00:00")
    private String useStart;

    @ApiModelProperty(value = "票种适用结束时间", example = "2020-12-01T14:00:00")
    private String useEnd;

    @ApiModelProperty(value = "票种说明", example = "这是票种说明")
    private String describes;

    @ApiModelProperty(value = "快递票种说明", example = "这是票种说明")
    private String describeExpress;

    @ApiModelProperty(value = "电子票种说明", example = "这是票种说明")
    private String describeElectronic;

    @ApiModelProperty(value = "票状态 -1删除;0未提交;1审核中;2审核中（自动在售）;3审核通过;4审核未通过;6在售;7停售;8售罄;9未开始;10已结束", example = "0")
    private Integer status;

    @ApiModelProperty(value = "是否展示二维码 0否 1是", example = "0")
    private Integer isShowCode;

    @ApiModelProperty(value = "二维码显示时间", example = "2020-12-01T14:00:00")
    private String qrCodeShowTime;

    @ApiModelProperty(value = "场次id")
    private String timesId;

    @ApiModelProperty(value = "是否开启缺票登记")
    private Integer isLackRegister;

    @ApiModelProperty(value = "剩余库存", example = "100")
    private Integer surplusGeneral;

    @ApiModelProperty(value = "剩余兑换库存", example = "100")
    private Integer surplusExchange;

    @ApiModelProperty(value = "快递类型 1寄付 2到付", example = "100")
    private Integer expressType;

    @ApiModelProperty(value = "是否开启转赠", example = "100")
    private Integer isTransfer;

    @ApiModelProperty(value = "是否 会员", example = "100")
    private Integer isMember;

    @ApiModelProperty(value = "是否专属", example = "100")
    private Integer isExclusive;

    @ApiModelProperty(value = "快递列表")
    private List<ExpressModuleVo> ExpressModuleList;

    @ApiModelProperty(value = "")
    private String createdAt;

    @ApiModelProperty(value = "")
    private String updatedAt;

    public void setDefault(){
        this.setIsMember(0);
        this.setIsTransfer(0);
        this.setIsExclusive(0);
        this.setSurplusExchange(this.getTotalExchange());
        this.setSurplusGeneral(this.getTotalGeneral());
    }

    public Integer getIdCount() {
        System.out.println("t p vo = "+(idCount==null?limitCount:idCount));
        return idCount==null?limitCount:idCount;
    }

    private static final KylinTicketPartnerVo obj = new KylinTicketPartnerVo();
    public static KylinTicketPartnerVo getNew() {
        try {
            return (KylinTicketPartnerVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinTicketPartnerVo();
        }
    }

    public KylinTicketPartnerVo copy(KylinTickets t, KylinTicketStatus ts, KylinTicketRelations tr,List<ExpressModuleVo> ExpressModuleList){
        this.ticketsId = t.getTicketsId();
        this.title = t.getTitle();
        this.isStudent = ts.getIsStudent();
        this.isElectronic = ts.getIsElectronic();
        this.isExpress = ts.getIsExpress();
        this.type = t.getType();
        this.price = t.getPrice();
        this.timeEndExpress = DateUtil.Formatter.yyyyMMddHHmmss.format(t.getTimeEndExpress());
        this.totalGeneral = ts.getTotalGeneral();
        this.totalExchange = ts.getTotalExchange();
        this.limitCount = ts.getLimitCount();
        this.idCount = ts.getIdCount();
        this.counts = ts.getCounts();
        this.timeStart = DateUtil.Formatter.yyyyMMddHHmmss.format(t.getTimeStart());
        this.timeEnd = DateUtil.Formatter.yyyyMMddHHmmss.format(t.getTimeEnd());
        this.useStart = DateUtil.Formatter.yyyyMMddHHmmss.format(t.getUseStart());
        this.useEnd = DateUtil.Formatter.yyyyMMddHHmmss.format(t.getUseEnd());
        this.describes = t.getDescribes();
        this.describeExpress = t.getDescribeExpress();
        this.describeElectronic = t.getDescribeElectronic();
        this.status = ts.getStatus();
        this.isShowCode = ts.getIsShowCode();
        this.qrCodeShowTime = DateUtil.Formatter.yyyyMMddHHmmss.format(ts.getQrCodeShowTime());
        this.timesId = tr.getTimesId();
        this.isLackRegister = ts.getIsLackRegister();
        this.surplusGeneral = ts.getSurplusGeneral();
        this.surplusExchange = ts.getSurplusExchange();
        this.expressType = ts.getExpressType();
        this.isTransfer = ts.getIsTransfer();
        this.isMember = ts.getIsMember();
        this.isExclusive = ts.getIsExclusive();
        this.ExpressModuleList = ExpressModuleList;
        this.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(t.getCreatedAt()));
        this.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(t.getUpdatedAt()));
        return this;
    }
}
