package com.liquidnet.common.cache.redis.config;//package com.liquidnet.common.cache.redis.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import java.util.List;


/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: RedisConfig
 * @Package com.liquidnet.common.cache.redis.config
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/8/10 16:28
 */
@Slf4j
@Configuration
public class RedisDb2Config extends AbstractRedisConfig{

    @Value("${spring.redis.db2.host:null}")
    private String host;
    @Value("${spring.redis.db2.port:-1}")
    private int port;
    @Value("${spring.redis.db2.password:null}")
    private String password;
    @Value("${spring.redis.db2.lettuce.pool.max-active:-1}")
    private int maxActive;
    @Value("${spring.redis.db2.lettuce.pool.max-idle:-1}")
    private int maxIdle;
    @Value("${spring.redis.db2.lettuce.pool.min-idle:-1}")
    private int minIdle;
    @Value("${spring.redis.db2.lettuce.pool.max-wait:-1}")
    private int maxWait;

    @Value("${spring.redis.db2.dbs:${spring.redis.db2.database:-1}}")
    private List<Integer> dbs;

    public RedisDb2Config(){

    }

    String getHost(){
        return this.host;
    }

    int getPort(){
        return this.port;
    }
    String getPassword(){
        return this.password;
    }
    int getMaxActive(){
        return this.maxActive;
    }
    int getMaxIdle(){
        return this.maxIdle;
    }
    int getMinIdle(){
        return this.minIdle;
    }
    int getMaxWait(){
        return this.maxWait;
    }
    List<Integer> getDbs(){
        return this.dbs;
    }
}