package com.liquidnet.common.cache.redis.util;

import com.liquidnet.common.cache.redis.config.AbstractRedisConfig;
import com.liquidnet.common.cache.redis.config.RedisDb4Config;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: Redis工具类
 * @class: RedisUtil
 * @Package com.liquidnet.stellar.utils
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/8/26 13:11
 */
@Slf4j
@Component("redisDb4Util")
public final class RedisDb4Util extends AbstractRedisUtil{
    @Autowired
    private RedisDb4Config redisConfig;

    @Override
    public int getDbs() {
        log.info("redisDb4Config.totalDbs===",redisConfig.totalDbs);
        return redisConfig.totalDbs;
    }

    @Override
    AbstractRedisConfig getRedisConfig() {
        return this.redisConfig;
    }
}
