package com.liquidnet.service.platform.test;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.dragon.dto.DragonOrdersDto;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestRedis
 * @Package com.liquidnet.service.adam.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/29 13:36
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestRedis {
    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    @Test
    public void pringRedisInitInfo(){
//        log.info("redisConfig.defaultDb===",redisConfig.defaultDb);
//        log.info("redisConfig.totalDbs===",redisConfig.totalDbs);
//        redisConfig.getRedisTemplateByDb(MathUtil.getIndex("1",redisConfig.defaultDb,redisConfig.totalDbs));
//
        System.out.println("RedisConfig.totalDbs==="+ redisDataSourceUtil.getRedisDb1Util().getDbs());
        System.out.println("RedisDb2Config.totalDbs==="+ redisDataSourceUtil.getRedisDb2Util().getDbs());
        System.out.println("RedisDb3Config.totalDbs==="+ redisDataSourceUtil.getRedisDb3Util().getDbs());
        System.out.println("RedisDb4Config.totalDbs==="+ redisDataSourceUtil.getRedisDb4Util().getDbs());
        System.out.println("RedisDb5Config.totalDbs==="+ redisDataSourceUtil.getRedisDb5Util().getDbs());
    }

    @Test
    public void getPayCodeList(){
//        List<Object> payCodeList = this.getPrefixKeyValue("dragon:pay:code:*");
//        for(Object payCode:payCodeList){
//            System.out.println("object=== "+ JsonUtils.toJson(payCode));
//        }
        //设置新的redis
        List<String> keys = getPrefixKeys("dragon:pay:code:*");
        log.info("总共迁移数据条数==="+keys.size());
        DragonOrdersDto dragonOrdersDto = DragonOrdersDto.getNew();
        for(String key:keys){
            Object obj = redisUtil.getRedisTemplateByDb(0).opsForValue().get(key);
            if(obj!=null){
                dragonOrdersDto =  (DragonOrdersDto) obj;
            }
//            redisUtil.set(key,dragonOrdersDto);
        }
//        System.out.println(redisUtil.sGet("kylin:agent:info"));
//        System.out.println(redisUtil.sHasKey("kylin:agent:info",14));

//        System.out.println(redisUtil.getRedisTemplateByDb(0).opsForValue().get("dragon:pay:code:PAY20210810193315191566757"));
//
//        List<Object> values = null;
//        // 获取所有的key
//        Set<String> keys = redisUtil.getRedisTemplateByDb(0).keys("dragon:pay:code:*");
//        if (null != keys){
//            for(String ss:keys){
//                System.out.println("ss====="+ss);
//            }
//            // 批量获取数据
//            values = redisUtil.getRedisTemplateByDb(0).opsForValue().multiGet(keys);
//        }
//        for(Object payCode:values){
//            System.out.println("object=== "+ JsonUtils.toJson(payCode));
//        }
    }

    @Test
    public void getRefundList(){
//        List<Object> payCodeList = this.getPrefixKeyValue("dragon:pay:code:*");
//        for(Object payCode:payCodeList){
//            System.out.println("object=== "+ JsonUtils.toJson(payCode));
//        }
        //设置新的redis
        List<String> keys = getPrefixKeys("dragon:refund:refundCode:dragon:refund:refundCode:*");
        String url = "";
        log.info("总共迁移数据条数==="+keys.size());
        for(String key:keys){
            Object obj = redisUtil.getRedisTemplateByDb(0).opsForValue().get(key);
            if(obj!=null){
                url =  (String) obj;
            }
            key = key.substring(25,key.length());
            redisUtil.set(key,url);
        }
//        System.out.println(redisUtil.sGet("kylin:agent:info"));
//        System.out.println(redisUtil.sHasKey("kylin:agent:info",14));

//        System.out.println(redisUtil.getRedisTemplateByDb(0).opsForValue().get("dragon:pay:code:PAY20210810193315191566757"));
//
//        List<Object> values = null;
//        // 获取所有的key
//        Set<String> keys = redisUtil.getRedisTemplateByDb(0).keys("dragon:pay:code:*");
//        if (null != keys){
//            for(String ss:keys){
//                System.out.println("ss====="+ss);
//            }
//            // 批量获取数据
//            values = redisUtil.getRedisTemplateByDb(0).opsForValue().multiGet(keys);
//        }
//        for(Object payCode:values){
//            System.out.println("object=== "+ JsonUtils.toJson(payCode));
//        }
    }

    @Test
    public void deleteDataFromDb(){

    }

    /**
     * 获取指定前缀的值
     * @param prefix key前缀
     * @return
     */
    public List<Object> getPrefixKeyValue(String prefix) {
        List<Object> values = null;
        // 获取所有的key
        Set<String> keys = redisUtil.getRedisTemplateByDb(0).keys(prefix);
        if (null != keys){
            for(String ss:keys){
                System.out.println("ss====="+ss);
            }
            // 批量获取数据
            values = redisUtil.getRedisTemplateByDb(0).opsForValue().multiGet(keys);
        }
        return values;
    }

    /**
     * 获取指定前缀的key
     * @param prefix key前缀
     * @return
     */
    public List<String> getPrefixKeys(String prefix) {
        List<String> keysList = new ArrayList<>();
        // 获取所有的key
        Set<String> keys = redisUtil.getRedisTemplateByDb(0).keys(prefix);
        if (null != keys){
            for(String ss:keys){
                keysList.add(ss);
            }
        }
        return keysList;
    }

    private void switchRedisDbs(){

    }
}
