package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "AdamLoginInfoVo", description = "登录成功响应数据")
@Data
public class AdamLoginInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 4209754800686327524L;
    @ApiModelProperty(position = 11, value = "TOKEN")
    private String token;
    @ApiModelProperty(position = 12, value = "用户信息")
    private AdamUserInfoVo userInfo;
    @ApiModelProperty(position = 13, value = "实名信息")
    private AdamRealInfoVo realNameInfo;
    @ApiModelProperty(position = 14, value = "用户第三方账号信息")
    private List<AdamThirdPartInfoVo> thirdPartInfo;
    @ApiModelProperty(position = 15, value = "会员信息 -> 待定")
    private Object memberInfo;

    private static final AdamLoginInfoVo obj = new AdamLoginInfoVo();

    public static AdamLoginInfoVo getNew() {
        try {
            return (AdamLoginInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamLoginInfoVo();
    }
}
