package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.entity.KylinTicketRelations;
import com.liquidnet.service.kylin.entity.KylinTicketStatus;
import com.liquidnet.service.kylin.entity.KylinTickets;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 修改场地全部显示数据参数
 */
@Data
public class TicketCreateParam implements Serializable {
    @ApiModelProperty(value = "主键")
    private String ticketsId;

    @ApiModelProperty(value = "场次Id")
    @NotNull(message = "场次ID不能为空")
    private String timesId;

    @ApiModelProperty(value = "票种名称", example = "测试票")
    @NotNull(message = "票种名称不能为空")
    private String title;

    @ApiModelProperty(value = "快递类型[0无类型|1寄付|2到付|3包邮]", example = "2")
    private Integer expressType;

    @ApiModelProperty(value = "快递模板[productCode数组]")
    private List<String> expressModule;

    @ApiModelProperty(value = "是否学生票 0否 1是", example = "0")
    @NotNull(message = "是否学生票不能为空")
    private Integer isStudent;

    @ApiModelProperty(value = "是否电子票", example = "1")
    @NotNull(message = "是否电子票不能为空")
    private Integer isElectronic;

    @ApiModelProperty(value = "快递票描述")
    private String describeExpress;

    @ApiModelProperty(value = "是否快递票", example = "0")
    @NotNull(message = "是否快递票不能为空")
    private Integer isExpress;

    @ApiModelProperty(value = "电子票描述")
    private String describeElectronic;

    @ApiModelProperty(value = "价格", example = "100.00")
    @NotNull(message = "价格不能为空")
    private BigDecimal price;

    @ApiModelProperty(value = "快递票截止日期", example = "2020-12-01T12:00:00")
    private LocalDateTime timeEndExpress;

    @ApiModelProperty(value = "总库存", example = "100")
    @NotNull(message = "总库存不能为空")
    private Integer totalGeneral;

    @ApiModelProperty(value = "总兑换库存", example = "100")
    @NotNull(message = "总兑换库存不能为空")
    private Integer totalExchange;

    @ApiModelProperty(value = "限购数量", example = "0")
    @NotNull(message = "限购数量不能为空")
    private Integer limitCount;

    @ApiModelProperty(value = "实名数量", example = "0")
    @NotNull(message = "限购数量不能为空")
    private Integer idCount;

    @ApiModelProperty(value = "票种开售时间", example = "2020-12-01T12:00:00")
    @NotNull(message = "票种开售时间不能为空")
    private LocalDateTime timeStart;

    @ApiModelProperty(value = "票种结售时间", example = "2020-12-01T14:00:00")
    @NotNull(message = "票种结售时间不能为空")
    private LocalDateTime timeEnd;

    @ApiModelProperty(value = "票种说明", example = "这是票种说明")
    private String describes;

    @ApiModelProperty(value = "是否展示二维码 0否 1是", example = "0")
    private Integer isShowCode;

    @ApiModelProperty(value = "二维码显示时间", example = "2020-12-01T14:00:00")
    private LocalDateTime qrCodeShowTime;

    @ApiModelProperty(value = "次数", example = "1")
    @NotNull(message = "次数不能为空")
    private Integer counts;

    @ApiModelProperty(value = "是否开启缺票登记", example = "1")
    @NotNull(message = "是否开启缺票登记不能为空")
    private Integer isLackRegister;

    @ApiModelProperty(value = "", hidden = true)
    private String createdAt;

    @ApiModelProperty(value = "票种类别 1：单人票 2：双人票 3:多人票")
    //@NotNull(message = "票种类别不能为空")
    private Integer ticketCategory;

    @ApiModelProperty(value = "票观演人数量")
    private Integer viewersNumber;

    @JsonIgnore
    public KylinTickets kylinTickets(String ticketsId, LocalDateTime createdAt, LocalDateTime updatedAt) {
        KylinTickets kylinTickets = new KylinTickets();
        BeanUtils.copyProperties(this, kylinTickets);
        kylinTickets.setTicketsId(ticketsId);
        kylinTickets.setPriceDiscount(BigDecimal.valueOf(0.00));
        kylinTickets.setPriceDiscountMember(BigDecimal.valueOf(0.00));
        if (createdAt != null)
            kylinTickets.setCreatedAt(createdAt);
        if (updatedAt != null)
            kylinTickets.setUpdatedAt(updatedAt);
        return kylinTickets;
    }

    @JsonIgnore
    public KylinTicketStatus kylinTicketStatus(String ticketsId, LocalDateTime createdAt, LocalDateTime updatedAt) {
        KylinTicketStatus kylinTicketStatus = new KylinTicketStatus();
        BeanUtils.copyProperties(this, kylinTicketStatus);
        kylinTicketStatus.setTicketStatusId(IDGenerator.nextSnowId().toString());
        kylinTicketStatus.setTicketId(ticketsId);
        kylinTicketStatus.setStatusExchange(7);
        kylinTicketStatus.setSurplusExchange(this.totalExchange);
        kylinTicketStatus.setSurplusGeneral(this.totalGeneral);
        kylinTicketStatus.setCounts(this.counts);
        if (createdAt != null)
            kylinTicketStatus.setCreatedAt(createdAt);
        if (updatedAt != null)
            kylinTicketStatus.setUpdatedAt(updatedAt);
        return kylinTicketStatus;
    }

    @JsonIgnore
    public KylinTicketRelations kylinTicketRelations(String ticketsId, LocalDateTime createdAt, LocalDateTime updatedAt) {
        KylinTicketRelations kylinTicketRelations = new KylinTicketRelations();
        BeanUtils.copyProperties(this, kylinTicketRelations);
        kylinTicketRelations.setTicketId(ticketsId);
        kylinTicketRelations.setTicketRelationsId(IDGenerator.nextSnowId().toString());
        if (createdAt != null)
            kylinTicketRelations.setCreatedAt(createdAt);
        if (updatedAt != null)
            kylinTicketRelations.setUpdatedAt(updatedAt);
        return kylinTicketRelations;
    }
}
