package com.liquidnet.service.slime.dto.vo;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.slime.entity.SlimeCompanies;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel(value = "SlimeCompaniesVo", description = "公司")
@Data
public class SlimeCompaniesVo implements java.io.Serializable, Cloneable  {
    private static final long serialVersionUID = -906817182104125502L;

    @ApiModelProperty(position = 10, value = "公司ID")
    private String companyId;
    @ApiModelProperty(position = 11, value = "企业名称")
    private String name;
    @ApiModelProperty(position = 12, value = "营业执照编号")
    private String licenseCode;
    @ApiModelProperty(position = 13, value = "营业执照图片地址")
    private String licenseImg;

    @ApiModelProperty(position = 20, value = "法人姓名")
    private String legalName;
    @ApiModelProperty(position = 21, value = "法人身份证号码")
    private String legalIdentity;
    @ApiModelProperty(position = 22, value = "法人身份证正面照")
    private String legalIdentityObverse;
    @ApiModelProperty(position = 23, value = "法人身份证反面照")
    private String legalIdentityReverse;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    private static final SlimeCompaniesVo obj = new SlimeCompaniesVo();

    public static SlimeCompaniesVo getNew() {
        try {
            return (SlimeCompaniesVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new SlimeCompaniesVo();
    }

    public SlimeCompaniesVo copy(SlimeCompanies source) {
        if (null == source) return this;

        this.setCompanyId(source.getCompanyId());
        this.setName(source.getName());
        this.setLicenseCode(source.getLicenseCode());
        this.setLicenseImg(source.getLicenseImg());

        this.setLegalName(source.getLegalName());
        this.setLegalIdentity(source.getLegalIdentity());
        this.setLegalIdentityObverse(source.getLegalIdentityObverse());
        this.setLegalIdentityReverse(source.getLegalIdentityReverse());

        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());

        return this;
    }
}
