package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreCouponVo;
import com.liquidnet.service.goblin.dto.vo.GoblinUserCouponBasicVo;
import com.liquidnet.service.goblin.dto.vo.GoblinUserCouponVo;
import com.liquidnet.service.goblin.service.GoblinCouponService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@Slf4j
@Service
public class GoblinCouponImpl implements GoblinCouponService {
    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;
    @Autowired
    QueueUtils queueUtils;

    @Override
    public ArrayList<String> getSpuType(String spuId, String storeId) {
        ArrayList<String> returnList = CollectionUtil.arrayListString();
        String pre = GoblinStatusConst.MarketPreStatus.getPre(spuId);
        if (pre != null) {
            spuId = spuId.split(pre)[0];
        }
        List<GoblinStoreCouponVo> listVo = goblinRedisUtils.getGoodsMarketsForCoupon(spuId, storeId);
        for (GoblinStoreCouponVo vo : listVo) {
            if (!returnList.contains(vo.getType()) && LocalDateTime.now().isAfter(vo.getStartTime()) && LocalDateTime.now().isBefore(vo.getEndTime())) {
                returnList.add(vo.getType());
            }
        }
        return returnList;
    }

    @Override
    public ArrayList<GoblinStoreCouponVo> getSpuByType(String spuId, String storeId, String type) {
        ArrayList<GoblinStoreCouponVo> returnList = ObjectUtil.getGoblinStoreCouponVoArrayList();
        String pre = GoblinStatusConst.MarketPreStatus.getPre(spuId);
        if (pre != null) {
            spuId = spuId.split(pre)[0];
        }
        List<GoblinStoreCouponVo> listVo = goblinRedisUtils.getGoodsMarketsForCoupon(spuId, storeId);
        for (GoblinStoreCouponVo vo : listVo) {
            if (vo.getType().equals(type) && LocalDateTime.now().isAfter(vo.getStartTime()) && LocalDateTime.now().isBefore(vo.getEndTime())) {
                vo.setStock(null);
                returnList.add(vo);
            }
        }
        return returnList;
    }

    @Override
    public Boolean receiveCoupon(String uid, List<GoblinUserCouponVo> userCouponVoList, GoblinStoreCouponVo storeCouponVo) {
        String storeCouponId = storeCouponVo.getStoreCouponId();
        LocalDateTime now = LocalDateTime.now();

        GoblinUserCouponBasicVo receiveUserCouponBasicVo = GoblinUserCouponBasicVo.getNew().initByStoreCouponVo(storeCouponVo);
        receiveUserCouponBasicVo.setUid(uid);
        receiveUserCouponBasicVo.setBindAt(now);
        receiveUserCouponBasicVo.setOperator(uid);
        receiveUserCouponBasicVo.setCreatedAt(now);

        userCouponVoList.add(GoblinUserCouponVo.getNew().copy(receiveUserCouponBasicVo));
        if (goblinRedisUtils.decrStoreCouponStock(storeCouponId, 1) >= 0) {
            goblinMongoUtils.insertUserCouponVo(receiveUserCouponBasicVo);
            goblinRedisUtils.setUserCouponVos(uid, userCouponVoList);

            LinkedList<Object[]> initUserCouponObjs = CollectionUtil.linkedListObjectArr();
            initUserCouponObjs.add(new Object[]{
                    receiveUserCouponBasicVo.getUcouponId(), receiveUserCouponBasicVo.getStoreCouponId(), receiveUserCouponBasicVo.getUid(),
                    receiveUserCouponBasicVo.getState(), receiveUserCouponBasicVo.getBindAt(), receiveUserCouponBasicVo.getDuedAt(),
                    receiveUserCouponBasicVo.getOperator(), receiveUserCouponBasicVo.getCreatedAt()
            });
            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                    SqlMapping.get("goblin_user_coupon.insert", initUserCouponObjs));
            return true;
        }
        goblinRedisUtils.incrStoreCouponStock(storeCouponId, 1);
        return false;
    }
}
