package com.liquidnet.service.platform.service.basicServices;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.dto.vo.admin.AdminUpushVo;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.entity.AdminUpush;
import com.liquidnet.service.kylin.mapper.AdminUpushMapper;
import com.liquidnet.service.kylin.service.admin.IAdminUpushService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 轮播图 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-02
 */
@Service
public class AdminUpushServiceImpl extends ServiceImpl<AdminUpushMapper, AdminUpush> implements IAdminUpushService {

    @Value("${liquidnet.al-oss.imgUrl}")
    private String imgUrl;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    RedisUtil redisUtil;

    public PageInfo<AdminUpushVo> lists(Integer page, Integer size) {
        PageInfo<AdminUpushVo> voPageInfo = null;
        Object adminUpushVo = redisUtil.get(KylinRedisConst.ADMIN_UPUSH_LIST);
        if (null == adminUpushVo) {
            voPageInfo = PageInfo.of(null);
        } else {
            // TODO: 2021/7/29 判断 安卓还是ios 还是全部 
            LinkedList<AdminUpushVo> pushList = (LinkedList<AdminUpushVo>) adminUpushVo;
            for (AdminUpushVo info : pushList) {
                if (!info.getImg().isEmpty()) {
                    String img = imgUrl + info.getImg();
                    info.setImg(img);
                }
            }
            voPageInfo = PageInfo.of(pushList);
            voPageInfo.setTotal(pushList.size());
        }
        return voPageInfo;
    }

}
