package com.liquidnet.service.base.constant;

public class MQConst {
    public enum AdamQueue {
        SMS_NOTICE("adam:stream:rk.sms.notice", "group.sms.sender", "短信通知"),
//        SMS_SPREAD("adam:stream:rk.sms.spread", "group.sms.sender", "短信推广"),

        SQL_UREGISTER("adam:stream:rk.sql.uregister", "group.sql.ucenter", "用户注册"),
        SQL_UCENTER("adam:stream:rk.sql.ucenter", "group.sql.ucenter", "用户中心"),
        SQL_UMEMBER("adam:stream:rk.sql.umember", "group.sql.ucenter", "购买会员"),
        ;
        private final String key;
        private final String group;
        private final String desc;

        AdamQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum KylinQueue {
        SMS_NOTICE("adam:stream:rk.sms.notice", "group.sms.sender", "短信通知"),
//        SMS_SPREAD("adam:stream:rk.sms.spread", "group.sms.sender", "短信推广"),

        SQL_PERFORMANCE_LACK("kylin:stream:rk.performance.lack", "group.performance.lack", "缺票登记"),
        SQL_ORDER_CREATE("kylin:stream:rk.order.create", "group.order.create", "创建订单"),
        SQL_ORDER_AGAIN("kylin:stream:rk.order.again", "group.order.again", "订单再次支付"),
        SQL_ORDER_CLOSE("kylin:stream:rk.order.close", "group.order.close", "订单关闭"),
        SQL_ORDER_PAY("kylin:stream:rk.order.pay", "group.order.pay", "订单支付"),
        SQL_ORDER_REFUND("kylin:stream:rk.order.refund", "group.order.refund", "订单申请退款"),
        SQL_ORDER_REFUND_EXPRESS("kylin:stream:rk.refundOrderExpress", "group.refundOrderExpress", "用户退款发快递"),
        SQL_ORDER_WITHDRAW("kylin:stream:rk.order.withdraw", "group.order.withdraw", "订单申请撤回"),
        SQL_ORDER_OVERTIME_REFUND("kylin:stream:rk.order.overtime.refund", "group.order.overtime.refund", "超时支付申请退款"),
        SQL_STATION("kylin:stream:rk.station", "group.station", "验票更新"),
        SQL_TRANSFER("kylin:stream:rk.transfer", "group.transfer", "订单发起转赠"),
        SQL_TRANSFER_RESULT("kylin:stream:rk.transfer.result", "group.transfer.result", "订单结果转赠"),
        SQL_TRANSFER_OVERTIME("kylin:stream:rk.transfer.overtime", "group.transfer.overtime", "订单结果转赠"),
        ;
        private final String key;
        private final String group;
        private final String desc;

        KylinQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }


    public enum SweetQueue {
        ARTISTS_RELATION("sweet:stream:rk.artists.relation", "group.artists.relation", "用户-关系"),
        ARTISTS_RELATION_MDSK("sweet:stream:rk.artists.mdsk.relation", "group.artists.mdsk.relation", "用户-关系"),
        LUCK_DRAW("sweet:stream:rk.luckDraw", "group.luckDraw", "用户-抽奖"),
        ANSWERINSERT_DRAW("sweet:stream:rk.answerInsert", "group.answerInsert", "答案"),
        SWEET_USER_INSERT_DRAW("sweet:stream:rk.sweetUserInsert", "group.sweetUserInsert", "关注服务号的用户信息"),
        SWEET_REMIND_INSERT_DRAW("sweet:stream:rk.remindInsert", "group.remindInsert", "提醒记录"),
        SWEET_APPLET_USER_INSERT_DRAW("sweet:stream:rk.sweetAppletUserInsert", "group.sweetAppletUserInsert", "小程序登录记录用户解密后信息"),
        SWEET_TEMPLATE_MSG("sweet:stream:rk.sweetTemplateMsg", "group.sweetTemplateMsg", "发送模版消息"),
        SWEET_CITY_VOTE_DRAW("sweet:stream:rk.cityVote", "group.cityVote", "用户投票记录"),
        SWEET_ANTIGENIC_QUESTION_DRAW("sweet:stream:rk.antigenicQuestion", "group.antigenicQuestion", "防疫答题"),
        ;

        private final String key;
        private final String group;
        private final String desc;

        SweetQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum CandyQueue {
        COUPON_USE("candy:stream:rk.coupon.use", "group.coupon.use", "券-使用"),
        COUPON_BACK("candy:stream:rk.coupon.back", "group.coupon.back", "券-回退"),
        COUPON_RECEIVE("candy:stream:rk.coupon.receive", "group.coupon.receive", "券-领取"),
        COUPON_ORDER_BACK("candy:stream:rk.coupon.order.back", "group.coupon.order.back", "券-订单-回退"),
        ;

        private final String key;
        private final String group;
        private final String desc;

        CandyQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum MerchantQueue {
        SQL_MERCHANT_FIELD("merchant:stream:rk.sql.field", "group.sql.field", "场地相关"),
        SQL_MERCHANT_SPONSOR("merchant:stream:rk.sql.sponsor", "group.sql.sponsor", "主办相关"),


        SQL_MERCHANT_TICKET_UPDATE("merchant:stream:rk.ticket", "group.ticket", "票种相关"),
        SQL_MERCHANT_PERFORMANCE_UPDATE("merchant:stream:rk.performance", "group.performance", "演出相关"),
        SQL_MERCHANT_STEP2("merchant:stream:rk.performance.step2", "group.performance.step2", "修改演出第二部"),
        SQL_MERCHANT_LINE("merchant:stream:rk.any.line", "group.any.line", "上下线相关"),
        SQL_MERCHANT_PERFORMANCE_INSERT("merchant:stream:rk.performance.insert", "group.performance.insert", "创建演出"),
        ;

        private final String key;
        private final String group;
        private final String desc;

        MerchantQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }
}
