package com.liquidnet.service.candy.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 公有券信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CandyCommonCoupon implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String ccouponId;

    /**
     * ~candy_mgt_coupon.mcoupon_id
     */
    private String mcouponId;

    /**
     * ~candy_coupon.coupon_id
     */
    private String couponId;

    /**
     * 公有券状态[1-可用|2-无效｜3-已过期]
     */
    private Integer state;

    /**
     * 公有券范围[10-全体用户｜20-全体会员]
     */
    private Integer ranged;

    private String comment;


}
