package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 18.请求人脸核身h5url
 * @class: FaceUrlReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:33
 */
@Data
public class Nft018FaceUrlReq implements Serializable {
    /**
     * 用户唯一标识
     */
    private String userIdentification;
    /**
     * browser:标识在浏览器启动刷脸 App:标识在App里启动刷脸，默认值为App
     */
    private String from;

    private static final Nft018FaceUrlReq obj = new Nft018FaceUrlReq();
    private static final long serialVersionUID = 9115310309826979911L;

    public static Nft018FaceUrlReq getNew() {
        try {
            return (Nft018FaceUrlReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft018FaceUrlReq();
        }
    }
}
