package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 43.NFT购买
 * @class: Nft043BuyReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:54
 */
@Data
public class Nft043BuyReq implements Serializable {
    /**
     * 要购买的nftId
     */
    private String nftId;
    /**
     * 申请多少积分给购买者
     */
    private Integer applyScore;
    /**
     * nft接收者公钥(也就是购买者)
     */
    private String receiverPubKey;
    /**
     * 积分接收地址
     */
    private String pointReceiverAddr;
    /**
     * 平台公钥
     */
    private String platformPubKey;
    /**
     * 出多少积分
     */
    private Long offerCount;
    /**
     * 请求ID，每个请求需要填唯一的ID，重复请求用相同的id
     */
    private String operateId;
    /**
     * 接收人的私钥签名，签名对象是(platformPubKey_receiverPubKey_pointReceiverAddr_applyScore_接口名_nftId_offerCount_operateId)
     * 接口名：buy_nft
     */
    private String signature;
    /**
     * 要购买的nftId
     */
    private String platformSignature;
    private static final Nft043BuyReq obj = new Nft043BuyReq();
    private static final long serialVersionUID = 2377617637622547202L;

    public static Nft043BuyReq getNew() {
        try {
            return (Nft043BuyReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft043BuyReq();
        }
    }

}
