package com.liquidnet.common.third.zxlnft.util;

import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.dto.nft.*;
import com.liquidnet.common.third.zxlnft.dto.wallet.*;
import com.liquidnet.common.third.zxlnft.service.WalletSdkService;
import com.liquidnet.common.third.zxlnft.service.ZxlnftSdkService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: EasemobUtil
 * @Package com.liquidnet.common.third.easemob.util
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/6 16:08
 */
@Slf4j
@Component
public class ZxlnftSdkUtil {
    @Autowired
    private ZxlnftConfig zxlnftConfig;
    @Autowired
    private WalletSdkService walletSdkService;

    @Autowired
    private ZxlnftSdkService zxlnftSdkService;



    public CreateMnemonicResp createMnemonic(CreateMnemonicReq req){
        CreateMnemonicResp resp = walletSdkService.createMnemonic(req);
        return resp;
    }

    public GenerateApiSignResp generateApiSign(GenerateApiSignReq req){
        GenerateApiSignResp resp = walletSdkService.generateApiSign(req);
        return resp;
    }

    public SignByPriKeyResp signByPriKey(SignByPriKeyReq req){
        SignByPriKeyResp resp = walletSdkService.signByPriKey(req);
        return resp;
    }

    public VerifyByPubKeyResp verifyByPubKey(VerifyByPubKeyReq req){
        VerifyByPubKeyResp resp = walletSdkService.verifyByPubKey(req);
        return resp;
    }


    public Nft016IdentityBindQueryResp nft016IdentityBindQuery(Nft016IdentityBindQueryReq req){
        req.setAddressList(zxlnftConfig.getNftPlatformAddress());
        Nft016IdentityBindQueryResp resp = zxlnftSdkService.nft016IdentityBindQuery(req);
        return resp;
    }
    public Nft021UploadUrlResp nft021UploadUrl(Nft021UploadUrlReq req){
        Nft021UploadUrlResp resp = zxlnftSdkService.nft021UploadUrl(req);
        return resp;
    }
    public Nft022UploadSecretResp nft022UploadSecret(Nft022UploadSecretReq req){
        Nft022UploadSecretResp resp = zxlnftSdkService.nft022UploadSecret(req);
        return resp;
    }
}
