package com.liquidnet.common.third.zxlnft.dto;

import com.liquidnet.commons.lang.util.JsonUtils;

import java.io.Serializable;

/**
 * 
 * @param <T>
 */
public class ZxlNftResponseDto<T> implements Serializable, Cloneable {
    private static final long serialVersionUID = 8377276776600901982L;
    private String retCode;
    private String retMsg;
    private T data;

    public boolean isSuccess() {
        return this.retCode.equals("0");
    }

    private ZxlNftResponseDto() {
    }

    private ZxlNftResponseDto(String retCode) {
        this.retCode = retCode;
    }

    private ZxlNftResponseDto(String retCode, T data) {
        this.retCode = retCode;
        this.data = data;
    }

    private ZxlNftResponseDto(String retCode, String retMsg) {
        this.retCode = retCode;
        this.retMsg = retMsg;
    }

    private ZxlNftResponseDto(String retCode, String retMsg, T data) {
        this.retCode = retCode;
        this.retMsg = retMsg;
        this.data = data;
    }

    /**
     * <p>Getter for the field <retCode>data</retCode>.</p>
     *
     * @return a T object.
     */
    public T getData() {
        return data;
    }

    public static <Object> ZxlNftResponseDto<Object> success() {
        return new ZxlNftResponseDto<>("0");
    }

    public static <Object> ZxlNftResponseDto<Object> success(Object data) {
        return new ZxlNftResponseDto<>("0", data);
    }

    public static <Object> ZxlNftResponseDto<Object> failure() {
        return new ZxlNftResponseDto<>("1", "系统繁忙，请稍后再试");
    }

    public static <Object> ZxlNftResponseDto<Object> failure(String retMsg) {
        return new ZxlNftResponseDto<>("1", retMsg);
    }

    public static <Object> ZxlNftResponseDto<Object> failure(String retCode, String retMsg) {
        return new ZxlNftResponseDto<>(retCode, retMsg);
    }

    public static <Object> ZxlNftResponseDto<Object> failure(String retCode, String retMsg, Object data) {
        return new ZxlNftResponseDto<>(retCode, retMsg, data);
    }

    public <T> T getParseData(Class<T> clazz) {
        try {
            if (getData() != null) {
                return JsonUtils.fromJson(JsonUtils.toJson(getData()), clazz);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String toJson() {
        return JsonUtils.toJson(this);
    }
}
