package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetRichtextTfc;
import com.liquidnet.service.sweet.mapper.SweetRichtextTfcMapper;
import com.liquidnet.service.sweet.service.ISweetRichtextTFCService;
import com.liquidnet.service.sweet.utils.RedisTFCDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 电子宣传手册富文本表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetRichtextTFCServiceImpl extends ServiceImpl<SweetRichtextTfcMapper, SweetRichtextTfc> implements ISweetRichtextTFCService {

    @Autowired
    private SweetRichtextTfcMapper sweetRichtextTFCMapper;
    @Autowired
    private RedisTFCDataUtils redisDataUtils;

    @Override
    public ResponseDto<SweetRichtextTfc> get(String manualId, Integer type) {
        try {
            return ResponseDto.success(sweetRichtextTFCMapper.selectOne(Wrappers.lambdaQuery(SweetRichtextTfc.class).eq(SweetRichtextTfc::getManualId, manualId).eq(SweetRichtextTfc::getType, type)));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String details, String local, String pirUrl, Integer type) {
        try {
            int count = sweetRichtextTFCMapper.selectCount(Wrappers.lambdaQuery(SweetRichtextTfc.class).eq(SweetRichtextTfc::getManualId, manualId).eq(SweetRichtextTfc::getType, type));
            if(count>0){
                return ResponseDto.failure("不能重复添加");
            }
            SweetRichtextTfc sweetRichtext = SweetRichtextTfc.getNew();
            sweetRichtext.setRichtextId(IDGenerator.nextSnowId());
            sweetRichtext.setManualId(manualId);
            if (type == 5) {
                sweetRichtext.setLocal(local);
                sweetRichtext.setDetails(details);
            } else if (type == 2) {
                sweetRichtext.setPicUrl(pirUrl);
            }else{
                sweetRichtext.setDetails(details);
            }
            sweetRichtext.setType(type);
            sweetRichtext.setCreatedAt(LocalDateTime.now());
            sweetRichtextTFCMapper.insert(sweetRichtext);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> change(String manualId, String details, String local, String pirUrl, Integer type) {
        try {
            SweetRichtextTfc sweetRichtext = SweetRichtextTfc.getNew();
            sweetRichtext.setRichtextId(IDGenerator.nextSnowId());
            sweetRichtext.setManualId(manualId);
            sweetRichtext.setDetails(details);
            if (type == 5) {
                sweetRichtext.setLocal(local);
            } else if (type == 2) {
                sweetRichtext.setPicUrl(pirUrl);
            }
            sweetRichtext.setType(type);
            sweetRichtext.setCreatedAt(LocalDateTime.now());
            sweetRichtextTFCMapper.update(sweetRichtext, Wrappers.lambdaUpdate(SweetRichtextTfc.class).eq(SweetRichtextTfc::getManualId, manualId).eq(SweetRichtextTfc::getType, type));

            redisDataUtils.setRichTextRedisData(manualId,type.toString(),sweetRichtext);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }

}
