# create database if not exists ln_scene character set utf8mb4 collate utf8mb4_unicode_ci;
# use ln_scene;

-- >>------------------------------------------------------------------------------------

drop table if exists slime_fields;
create table slime_fields
(
    mid           bigint unsigned auto_increment primary key,
    field_id      varchar(64)             not null comment 'field_id',
    is_online     tinyint      default 0  not null comment '上线状态 0下线 1上线',
    claim_status  tinyint      default 0  not null comment '认领状态 0未认领 1已认领 2认领中',
    uid           varchar(64)  default '' not null comment '场地所有者账号',
    is_check      tinyint      default 0  not null comment '审核演出开关 0不审 1审核',
    name          varchar(255) default '' not null comment '名称',
    logo          varchar(255) default '' not null comment 'logo图片地址',
    background    varchar(255) default '' not null comment '背景图片地址',
    description   text                    null comment '介绍',
    built_date    date                    null comment '建立日期',
    province_id   varchar(64)  default '' not null comment '省份ID',
    province_name varchar(255) default '' not null comment '省份名称',
    city_id       varchar(64)  default '' not null comment '城市ID',
    city_name     varchar(255) default '' not null comment '城市名称',
    district_id   varchar(64)  default '' not null comment '区县ID',
    district_name varchar(255) default '' not null comment '区县名称',
    address       varchar(255) default '' not null comment '详细地址',
    longitude     varchar(255) default '' not null comment '经度',
    latitude      varchar(255) default '' not null comment '纬度',
    contact_name  varchar(255) default '' not null comment '联系人姓名',
    contact_email varchar(255) default '' not null comment '联系人邮箱',
    company_id    varchar(64)  default '' not null comment '企业信息ID',
    created_at    timestamp               null,
    updated_at    timestamp               null
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_unicode_ci comment '场地表';

create unique index field_id_index on slime_fields (field_id);
create index uid_index on slime_fields (uid);
create index company_id_index on slime_fields (company_id);

-- >>------------------------------------------------------------------------------------

drop table if exists slime_field_checkers;
create table slime_field_checkers
(
    mid              bigint unsigned auto_increment primary key,
    field_checker_id varchar(64)             not null comment 'field_apply_id',
    field_id         varchar(64)  default '' not null comment '场地ID',
    uid              varchar(64)  default '' not null comment '验票员账号',
    mobile           varchar(255) default '' not null comment '手机号',
    name             varchar(255) default '' not null comment '姓名',
    cuid             varchar(64)  default '' not null comment '授权人账号',
    deleted_at       timestamp               null,
    created_at       timestamp               null,
    updated_at       timestamp               null
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_unicode_ci comment '场地默认验票员表';

create unique index field_checker_id_index on slime_field_checkers (field_checker_id);
create index field_id_index on slime_field_checkers (field_id);
create index uid_index on slime_field_checkers (uid);
create index cuid_index on slime_field_checkers (cuid);

-- >>------------------------------------------------------------------------------------

drop table if exists slime_field_applies;
create table slime_field_applies
(
    mid                    bigint unsigned auto_increment primary key,
    field_apply_id         varchar(64)             not null comment 'field_apply_id',
    apply_status           tinyint      default 0  not null comment '申请状态 0待审核 1通过 2驳回',
    apply_type             varchar(255) default '' not null comment '类型 claim认领、create创建',
    reject                 varchar(255) default '' not null comment '驳回原因',
    uid                    varchar(64)  default '' not null comment '申请者账号',
    field_id               varchar(64)  default '' not null comment '认领的或创建的场地ID',
    name                   varchar(255) default '' not null comment '名称',
    logo                   varchar(255) default '' not null comment 'logo图片地址',
    background             varchar(255) default '' not null comment '背景图片地址',
    description            text                    null comment '介绍',
    built_date             date                    null comment '建立日期',
    province_id            varchar(64)  default '' not null comment '省份ID',
    province_name          varchar(255) default '' not null comment '省份名称',
    city_id                varchar(64)  default '' not null comment '城市ID',
    city_name              varchar(255) default '' not null comment '城市名称',
    district_id            varchar(64)  default '' not null comment '区县ID',
    district_name          varchar(255) default '' not null comment '区县名称',
    address                varchar(255) default '' not null comment '详细地址',
    longitude              varchar(255) default '' not null comment '经度',
    latitude               varchar(255) default '' not null comment '纬度',
    contact_name           varchar(255) default '' not null comment '联系人姓名',
    contact_email          varchar(255) default '' not null comment '联系人邮箱',
    company_name           varchar(255) default '' not null comment '企业名称',
    license_code           varchar(255) default '' not null comment '营业执照编号',
    license_img            varchar(255) default '' not null comment '营业执照图片地址',
    legal_name             varchar(255) default '' not null comment '法人姓名',
    legal_identity         varchar(255) default '' not null comment '法人身份证号码',
    legal_identity_obverse varchar(255) default '' not null comment '法人身份证正面照',
    legal_identity_reverse varchar(255) default '' not null comment '法人身份证反面照',
    audit_uid              varchar(64)  default '' not null comment '审核人ID',
    audit_name             varchar(255) default '' not null comment '审核人姓名',
    audited_at             timestamp               null,
    deleted_at             timestamp               null,
    created_at             timestamp               null,
    updated_at             timestamp               null
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_unicode_ci comment '场地申请表';

create unique index field_apply_id_index on slime_field_applies (field_apply_id);
create index field_id_index on slime_field_applies (field_id);
create index uid_index on slime_field_applies (uid);

-- >>------------------------------------------------------------------------------------

drop table if exists slime_sponsors;
create table slime_sponsors
(
    mid                      bigint unsigned auto_increment primary key,
    sponsor_id               varchar(64)             not null comment 'sponsor_id',
    is_online                tinyint      default 0  not null comment '上线状态 0下线 1上线',
    uid                      varchar(64)  default '' not null comment '主办所有者账号',
    name                     varchar(255) default '' not null comment '名称',
    logo                     varchar(255) default '' not null comment 'logo图片地址',
    background               varchar(255) default '' not null comment '背景图片地址',
    description              text                    null comment '介绍',
    contact_name             varchar(255) default '' not null comment '联系人姓名',
    contact_identity         varchar(255) default '' not null comment '联系人身份证号码',
    contact_identity_obverse varchar(255) default '' not null comment '联系人身份证正面照',
    contact_identity_reverse varchar(255) default '' not null comment '联系人身份证反面照',
    contact_email            varchar(255) default '' not null comment '联系人邮箱',
    company_id               varchar(64)  default '' not null comment '企业信息ID',
    created_at               timestamp               null,
    updated_at               timestamp               null
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_unicode_ci comment '主办表';

create unique index sponsor_id_index on slime_sponsors (sponsor_id);
create index uid_index on slime_sponsors (uid);
create index company_id_index on slime_sponsors (company_id);

-- >>------------------------------------------------------------------------------------

drop table if exists slime_sponsor_applies;
create table slime_sponsor_applies
(
    mid                      bigint unsigned auto_increment primary key,
    sponsor_apply_id         varchar(64)             not null comment 'sponsor_apply_id',
    apply_status             tinyint      default 0  not null comment '申请状态 0待审核 1通过 2驳回',
    apply_type               varchar(255) default '' not null comment '类型 create创建',
    reject                   varchar(255) default '' not null comment '驳回原因',
    uid                      varchar(64)  default '' not null comment '申请者账号',
    sponsor_id               varchar(64)  default '' not null comment '创建的主办ID',
    name                     varchar(255) default '' not null comment '名称',
    logo                     varchar(255) default '' not null comment 'logo图片地址',
    background               varchar(255) default '' not null comment '背景图片地址',
    description              text                    null comment '介绍',
    contact_name             varchar(255) default '' not null comment '联系人姓名',
    contact_identity         varchar(255) default '' not null comment '联系人身份证号码',
    contact_identity_obverse varchar(255) default '' not null comment '联系人身份证正面照',
    contact_identity_reverse varchar(255) default '' not null comment '联系人身份证反面照',
    contact_email            varchar(255) default '' not null comment '联系人邮箱',
    company_name             varchar(255) default '' not null comment '企业名称',
    license_code             varchar(255) default '' not null comment '营业执照编号',
    license_img              varchar(255) default '' not null comment '营业执照图片地址',
    legal_name               varchar(255) default '' not null comment '法人姓名',
    legal_identity           varchar(255) default '' not null comment '法人身份证号码',
    legal_identity_obverse   varchar(255) default '' not null comment '法人身份证正面照',
    legal_identity_reverse   varchar(255) default '' not null comment '法人身份证反面照',
    audit_uid                varchar(64)  default '' not null comment '审核人ID',
    audit_name               varchar(255) default '' not null comment '审核人姓名',
    audited_at               timestamp               null,
    deleted_at               timestamp               null,
    created_at               timestamp               null,
    updated_at               timestamp               null
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_unicode_ci comment '主办申请表';

create unique index sponsor_apply_id_index on slime_sponsor_applies (sponsor_apply_id);
create index sponsor_id_index on slime_sponsor_applies (sponsor_id);
create index uid_index on slime_sponsor_applies (uid);

-- >>------------------------------------------------------------------------------------

drop table if exists slime_companies;
create table slime_companies
(
    mid                    bigint unsigned auto_increment primary key,
    company_id             varchar(64)             not null comment 'company_id',
    name                   varchar(255) default '' not null comment '企业名称',
    license_code           varchar(255) default '' not null comment '营业执照编号',
    license_img            varchar(255) default '' not null comment '营业执照图片地址',
    legal_name             varchar(255) default '' not null comment '法人姓名',
    legal_identity         varchar(255) default '' not null comment '法人身份证号码',
    legal_identity_obverse varchar(255) default '' not null comment '法人身份证正面照',
    legal_identity_reverse varchar(255) default '' not null comment '法人身份证反面照',
    created_at             timestamp               null,
    updated_at             timestamp               null
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_unicode_ci comment '公司表';

create unique index company_id_index on slime_companies (company_id);

-- >>------------------------------------------------------------------------------------

drop table if exists slime_authorization_records;
create table slime_authorization_records
(
    mid                     bigint unsigned auto_increment primary key,
    authorization_record_id varchar(64)             not null comment 'authorization_record_id',
    performance_id          varchar(64)             not null comment '演出ID',
    uid_role                varchar(255) default '' not null comment '权利人演出角色[creator|sponsor|fielder|checker]',
    uid                     varchar(64)             not null comment '权利人',
    mobile                  varchar(255) default '' not null comment '手机号',
    name                    varchar(255) default '' not null comment '姓名',
    cuid_role               varchar(255) default '' not null comment '授权人演出角色[creator|sponsor|fielder]',
    cuid                    varchar(64)             not null comment '授权人',
    deleted_at              timestamp               null,
    created_at              timestamp               null,
    updated_at              timestamp               null
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_unicode_ci comment '演出授权记录表';

create unique index authorization_record_id_index on slime_authorization_records (authorization_record_id);
create index performance_id_index on slime_authorization_records (performance_id);
create index cuid_index on slime_authorization_records (cuid);
create index cuid_role_index on slime_authorization_records (cuid_role);
create index uid_index on slime_authorization_records (uid);
create index uid_role_index on slime_authorization_records (uid_role);

-- >>------------------------------------------------------------------------------------

drop table if exists slime_permissions;
create table slime_permissions
(
    mid           bigint unsigned auto_increment primary key,
    permission_id varchar(64)  not null comment 'permission_id',
    name          varchar(255) not null comment '名称',
    created_at    timestamp    null,
    updated_at    timestamp    null
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_unicode_ci comment '演出权限表';

create unique index permission_id_index on slime_permissions (permission_id);

-- >>------------------------------------------------------------------------------------

drop table if exists slime_authorization_permissions;
create table slime_authorization_permissions
(
    mid                         bigint unsigned auto_increment primary key,
    authorization_permission_id varchar(64) not null comment 'authorization_permission_id',
    authorization_record_id     varchar(64) not null comment 'authorization_record_id',
    permission_id               varchar(64) not null comment 'permission_id',
    start_time                  datetime    null comment '授权开始时间',
    end_time                    datetime    null comment '授权结束时间',
    created_at                  timestamp   null,
    updated_at                  timestamp   null
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_unicode_ci comment '演出授权关联权限表';

create unique index authorization_permission_id_index on slime_authorization_permissions (authorization_permission_id);
create index authorization_record_id_index on slime_authorization_permissions (authorization_record_id);
create index permission_id_index on slime_authorization_permissions (permission_id);

-- >>------------------------------------------------------------------------------------
-- >>------------------------------------------------------------------------------------
-- >>------------------------------------------------------------------------------------

alter table kylin_ticket_status modify qr_code_show_time datetime default '2030-01-01 12:00:00' null comment '二维码显示时间';
alter table kylin_tickets modify time_end_express datetime default '2030-01-01 12:00:00' null comment '快递票结束时间';
alter table kylin_performance_status ADD field_audit_status int default 0 null comment '场地审核状态[0-审核完成|1-待审核|2-已拒绝]';
alter table kylin_order_ticket_status ADD produce_code varchar(64) default '' null comment '快递模板code';


drop table if exists kylin_ticket_express_module;
create table kylin_ticket_express_module
(
    mid        bigint unsigned auto_increment primary key,
    ticket_id  varchar(64) default '' comment '票种id',
    produce_code  varchar(64) default '' comment '快递模板code',
    created_at datetime ,
    updated_at datetime ,
    comment    text
) engine = InnoDB comment '票种快递模板关联表';


ALTER TABLE kylin_performance_status
ADD id_count int DEFAULT NULL COMMENT '实名限购数';
ALTER TABLE kylin_ticket_status
ADD id_count int DEFAULT NULL COMMENT '实名限购数';