package com.liquidnet.service.adam.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.AdamEntersParam;
import com.liquidnet.service.adam.dto.AdamMemberParam;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.service.IAdamMemberService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "会员信息")
@Slf4j
@RestController
@RequestMapping("/member")
public class AdamMemberController {

    @Autowired
    IAdamMemberService adamMemberService;
    @Autowired
    AmqpTemplate amqpTemplate;

    @ApiOperationSupport(order = 0)
    @ApiOperation(value = "会员信息")
    @GetMapping("info/{id}")
    public ResponseDto<Object> query(@PathVariable(name = "id", required = true) String memberId) {
        AdamMember info = adamMemberService.query(memberId);
        return ResponseDto.success(info);
    }

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "添加会员")
    @PostMapping("add")
    public ResponseDto<Object> add(@RequestBody AdamMemberParam parameter) {
        AdamMember adamMember = new AdamMember();
        BeanUtils.copyProperties(parameter, adamMember);

        adamMember.setLimitation(1000);
        adamMember.setType(1);
        adamMember.setStartNo(1000);
        adamMember.setMemberId(String.valueOf(IDGenerator.nextSnowId()));
        adamMemberService.add(adamMember);
        return ResponseDto.success();
    }

}
