package com.liquidnet.service.consumer.kylin.receiver;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.OrderCloseMapping;
import com.liquidnet.service.consumer.kylin.Utils.KylinUtils;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamListener;

@Slf4j
public abstract class AbstractSqlOptOrderCloseRedisReceiver implements StreamListener<String, MapRecord<String, String, String>> {
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private KylinUtils kylinUtils;

    @Override
    public void onMessage(MapRecord<String, String, String> message) {
        log.info("CONSUMER SQL[streamKey:{},messageId:{},stream:{},body:{}]",
                this.getRedisStreamKey(), message.getId(), message.getStream(), message.getValue());

        boolean result = this.consumerSqlOperationOrderCloseHandler(message.getValue().get("message"));

        log.debug("CONSUMER SQL RESULT:{}", result);

        // 消费成功确认，消息删除和消息确认是一个事务
        if (result) {
            log.info("CONSUMER SMS SUCC ==> MESSAGE_ID:{}", message.getId());
            try {
                stringRedisTemplate.opsForStream().delete(this.getRedisStreamKey(), message.getId());
            } catch (Exception e) {
                log.error("CONSUMER SMS SUCC ==> DEL_REDIS_QUEUE_MSG_EXCEPTION[MESSAGE_ID:{}]", message.getId(), e);
            }
        }
    }

    private boolean consumerSqlOperationOrderCloseHandler(String msg) {
        try {
            OrderCloseMapping.orderCloseMessage mqMessage = JsonUtils.fromJson(msg, OrderCloseMapping.orderCloseMessage.class);

            for (int x = 0; x < mqMessage.getOrderTicketIds().size(); x++) {
                String t = mqMessage.getOrderTicketIds().get(x);
                String orderTicketId = t.split(",")[0];
                String uid = t.split(",")[1];
                KylinOrderTicketVo vo = kylinUtils.getOrderTicketVo(orderTicketId);
                vo.setStatus(2);
                redisUtil.set("kylin:order:id:" + orderTicketId, vo);

                kylinUtils.resetOrderListVo(uid, 2, orderTicketId, vo);
                // redis 限购
                for (int i = 0; i < vo.getEntitiesVoList().size(); i++) {
                    KylinOrderTicketEntitiesVo items = vo.getEntitiesVoList().get(i);
                    kylinUtils.changeBuyInfo(items.getUserId(), items.getEnterIdCode(), items.getPerformanceId(), items.getTicketId(), -1);
                }
            }

            return true;
        } catch (Exception e) {
            log.error("CONSUMER SMS FAIL ==> {}", e.getMessage(), e);
            return false;
        }
    }

    protected abstract String getRedisStreamKey();
}
