/**
 * $Id$
 * Copyright(C) 2015-2020 kowlone - internet center, All Rights Reserved.
 */
package com.liquidnet.service;

import java.io.Serializable;

/**
 * 分页显示的结果
 * @author <a href="mailto:lzm8285@163.com">Li Zhongmin</a>
 * @version 1.0 2015年12月08日 17:44:00
 */
public class PagedResult<T> implements Serializable{

	private static final long serialVersionUID = 9014763784496485161L;
	/** 总页数 */
	private int totalPages;
	/** 总记录数 */
	private int totalRows;
	/** 分页数据 */
	private T data;

	public PagedResult(){}

	public PagedResult(T data,Object page) {
		this.data = data;
	}

	public PagedResult(T data,int totalPages,int totalRows) {
		this.totalPages = totalPages;
		this.totalRows = totalRows;
		this.data = data;
	}


	public T getData() {
		return data;
	}

	public int getTotalPages() {
		return totalPages;
	}

	public int getTotalRows() {
		return totalRows;
	}
}
